/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphReachability;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class UnreachableCodeElimination
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(UnreachableCodeElimination.class.getName());
    private final AbstractCompiler compiler;
    private final boolean removeNoOpStatements;
    private boolean codeChanged;

    UnreachableCodeElimination(AbstractCompiler compiler, boolean removeNoOpStatements) {
        this.compiler = compiler;
        this.removeNoOpStatements = removeNoOpStatements;
    }

    @Override
    public void process(Node externs, Node toplevel) {
        NodeTraversal.traverseChangedFunctions(this.compiler, new NodeTraversal.FunctionCallback(){

            @Override
            public void visit(AbstractCompiler compiler, Node root) {
                ControlFlowAnalysis cfa = new ControlFlowAnalysis(compiler, false, false);
                cfa.process(null, root);
                ControlFlowGraph<Node> cfg = cfa.getCfg();
                new GraphReachability(cfg).compute(cfg.getEntry().getValue());
                if (root.isFunction()) {
                    root = root.getLastChild();
                }
                do {
                    UnreachableCodeElimination.this.codeChanged = false;
                    NodeTraversal.traverse(compiler, root, new EliminationPass(cfg));
                } while (UnreachableCodeElimination.this.codeChanged);
            }
        });
    }

    private class EliminationPass
    extends NodeTraversal.AbstractShallowCallback {
        private final ControlFlowGraph<Node> cfg;

        private EliminationPass(ControlFlowGraph<Node> cfg) {
            this.cfg = cfg;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (parent == null || n.isFunction() || n.isScript()) {
                return;
            }
            DiGraph.DiGraphNode gNode = this.cfg.getDirectedGraphNode(n);
            if (gNode == null) {
                return;
            }
            if (gNode.getAnnotation() != GraphReachability.REACHABLE || UnreachableCodeElimination.this.removeNoOpStatements && !NodeUtil.mayHaveSideEffects(n, UnreachableCodeElimination.this.compiler)) {
                this.removeDeadExprStatementSafely(n);
                return;
            }
            this.tryRemoveUnconditionalBranching(n);
        }

        private void tryRemoveUnconditionalBranching(Node n) {
            if (n == null) {
                return;
            }
            DiGraph.DiGraphNode gNode = this.cfg.getDirectedGraphNode(n);
            if (gNode == null) {
                return;
            }
            switch (n.getType()) {
                case 4: {
                    if (n.hasChildren()) break;
                }
                case 116: 
                case 117: {
                    List outEdges = gNode.getOutEdges();
                    if (outEdges.size() != 1 || n.getNext() != null && !n.getNext().isFunction()) break;
                    Preconditions.checkState((outEdges.get(0).getValue() == ControlFlowGraph.Branch.UNCOND ? 1 : 0) != 0);
                    Node fallThrough = this.computeFollowing(n);
                    Node nextCfgNode = (Node)outEdges.get(0).getDestination().getValue();
                    if (nextCfgNode != fallThrough || this.inFinally(n.getParent(), n)) break;
                    this.removeNode(n);
                }
            }
        }

        private boolean inFinally(Node parent, Node child) {
            if (parent == null || parent.isFunction()) {
                return false;
            }
            if (NodeUtil.isTryFinallyNode(parent, child)) {
                return true;
            }
            return this.inFinally(parent.getParent(), parent);
        }

        private Node computeFollowing(Node n) {
            Node next = ControlFlowAnalysis.computeFollowNode(n);
            while (next != null && next.isBlock()) {
                if (next.hasChildren()) {
                    next = next.getFirstChild();
                    continue;
                }
                next = this.computeFollowing(next);
            }
            return next;
        }

        private void removeDeadExprStatementSafely(Node n) {
            Node parent = n.getParent();
            if (n.isEmpty() || n.isBlock() && !n.hasChildren()) {
                return;
            }
            if (NodeUtil.isForIn(parent)) {
                return;
            }
            switch (n.getType()) {
                case 114: {
                    return;
                }
                case 125: {
                    if (!parent.isTry() || !NodeUtil.isTryCatchNodeContainer(n)) break;
                    return;
                }
                case 120: {
                    Node tryNode = parent.getParent();
                    NodeUtil.maybeAddFinally(tryNode);
                }
            }
            if (n.isVar() && !n.getFirstChild().hasChildren()) {
                return;
            }
            this.removeNode(n);
        }

        private void removeNode(Node n) {
            UnreachableCodeElimination.this.codeChanged = true;
            NodeUtil.redeclareVarsInsideBranch(n);
            UnreachableCodeElimination.this.compiler.reportCodeChange();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing " + n.toString());
            }
            NodeUtil.removeChild(n.getParent(), n);
        }
    }
}

