package com.xebialabs.xltest.domain;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.script.ScriptContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.RepositoryService;

@SuppressWarnings("serial")
@Metadata(description = "Report base type", root = Metadata.ConfigurationItemRoot.CONFIGURATION, virtual = true)
public class Report extends ScriptedConfigurationItem  implements Computable<TestRun, Object> {
	private static final Logger LOG = LoggerFactory.getLogger(Report.class);

	@Property(description = "List of TestSetDefinitions which the reporting tool can handle on the given url", required = false)
	private List<String> testSetTypes;

    @Property(description = "The type of report. One of 'link', 'highchart', 'table', 'html', 'qualification'")
    private String reportType;

    @Autowired
    private transient RepositoryService repository;

    private Map<String, Object> attributes = new TreeMap();

    public Report(){
	}

	public List<String> getTestSetTypes() {
		return testSetTypes;
	}

	public void setTestSetTypes(List<String> testSetTypes) {
		this.testSetTypes = testSetTypes;
	}

    public String getReportType() {
        return reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    @Override
    public Object compute(TestRun testRun) {
        ScriptContext context = getScriptContext();
        for (String key : attributes.keySet()) {
            context.setAttribute(key, attributes.get(key), ScriptContext.ENGINE_SCOPE);
        }
        context.setAttribute("testRun", testRun, ScriptContext.ENGINE_SCOPE);
        context.setAttribute("repository", repository, ScriptContext.ENGINE_SCOPE);
        try {
            LOG.debug("About to generate report");
            Object result = execute(context);
            // TODO: -AJM- Ouch! We're about to update the test run here! Move this to TestRunner.
            if (thisIsAQualification(testRun)) {
            	storeQualificationResultInRun(result, testRun);
            }
            return result;
        } catch (Exception e) {
            throw new RuntimeException("Could not perform report transformation.", e);
        }
    }

    private void storeQualificationResultInRun(Object result, TestRun testRun) {
    	if (result instanceof Boolean) {
	    	testRun.setQualificationResult(((Boolean)result).booleanValue());
	    	repository.update(testRun);
    	} else {
    		LOG.warn("Qualification result is not a Boolean. I got: {}", result);
    	}
	}

	private boolean thisIsAQualification(TestRun testRun) {
    	return testRun.getTestSetDefinition().getQualification() != null &&
    			getId().equals(testRun.getTestSetDefinition().getQualification().getId());
	}

	public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }

    protected RepositoryService getRepository() {
        return repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }
}
