package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.xltest.plan.Plan;
import com.xebialabs.xltest.plan.TestPlan;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import org.slf4j.LoggerFactory;

import java.io.FileNotFoundException;

@Metadata(description = "A Test set definition", root = Metadata.ConfigurationItemRoot.CONFIGURATION, virtual = true)
public class TestSetDefinition extends ScriptedConfigurationItem implements Planable<Plan> {

    @Property(description = "The report used to determine the outcome of a test run (success/fail)", required = false)
    private Report qualification;
    @Property(description = "The maximum number of minutes this test may execute", required = false)
    private int timeout;
    @Property(description = "When the test run times out, run this command to e.g. clean up", required = false)
    private String cleanupCommandUponTimeout;

    public static <T extends TestSetDefinition> T create(String id, Type type) {
        Descriptor reporterDescriptor = DescriptorRegistry.getDescriptor(type);
        return reporterDescriptor.newInstance(id);
    }

    public Plan plan() {
        try {
            return execute(getScriptContext());
        } catch (FileNotFoundException e) {
            LoggerFactory.getLogger(getType().toString()).info("Could not find plan script. Deferring to default.");
            return new TestPlan(this, defaultCommandLine());
        } catch (ScriptExecutionException e) {
            throw new RuntimeException("Could not create plan.", e);
        }
    }

    /**
     * Default command line implementation, the type's name.
     *
     * @return a default command line.
     */
    public CmdLine defaultCommandLine() {
        return new CmdLine().addArgument(getType().getName());
    }

    public void setQualification(Report qualification) {
        this.qualification = qualification;
    }

    public Report getQualification() {
        return qualification;
    }

	public int getTimeout() {
		return timeout;
	}

	public void setTimeout(int timeout) {
		this.timeout = timeout;
	}

    // TODO: this property is smelly
	public String getCleanupCommandUponTimeout() {
		return cleanupCommandUponTimeout;
	}

	public void setCleanupCommandUponTimeout(String cleanupCommandUponTimeout) {
		this.cleanupCommandUponTimeout = cleanupCommandUponTimeout;
	}
	
    
}
