package com.xebialabs.xltest.domain.definitions;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.xltest.domain.TestSetDefinition;

public class CommandLine extends TestSetDefinition {

    @Property
    private String commandLine;

    public static CommandLine create(String id, String commandLine) {
        CommandLine testSetDefinition = TestSetDefinition.create(id, Type.valueOf(CommandLine.class));

        testSetDefinition.setCommandLine(commandLine);
        return testSetDefinition;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public CmdLine defaultCommandLine() {
        return new CmdLine().addRaw(commandLine);
    }
}
