package com.xebialabs.xltest.domain.definitions;

import static java.util.Collections.emptyList;

import java.util.LinkedList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.plan.LeadTimePlan;
import com.xebialabs.xltest.plan.ParallelPlan;
import com.xebialabs.xltest.plan.Plan;
import com.xebialabs.xltest.plan.SerialPlan;
import org.python.google.common.collect.Lists;

public class SuperSet extends TestSetDefinition {

    @Property
    private List<TestSetDefinition> sets = emptyList();

    @Property(defaultValue = "false")
    private boolean parallel;
    
    @Property
    private int leadTime;

    public List<TestSetDefinition> getSets() {
        return sets;
    }

    public void setSets(List<TestSetDefinition> sets) {
        this.sets = sets;
    }

    public boolean isParallel() {
        return parallel;
    }

    @Override
    public Plan plan() {
        List<Plan> plans = new LinkedList<>();
        int leadTimeInsec = 0;
        for (TestSetDefinition set : sets) {
            plans.add(new SerialPlan(Lists.newArrayList(new LeadTimePlan(leadTimeInsec), set.plan())));
            leadTimeInsec = leadTimeInsec + getLeadTime();
        }
        return parallel ? new ParallelPlan(plans) : new SerialPlan(plans);
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

	public int getLeadTime() {
		return leadTime;
	}

	public void setLeadTime(int leadTime) {
		this.leadTime = leadTime;
	}
    
}
