package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.TestSetDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.Collection;

import static com.xebialabs.deployit.plugin.api.reflect.Type.valueOf;

@Repository
public class TestSets {
    private final RepositoryService repository;

    @Autowired
    public TestSets(RepositoryService repository) {
        this.repository = repository;
    }
    public void addTestSetDefinition(TestSetDefinition testSetDefinition) {
        repository.create(testSetDefinition);
    }
    
    public void updateTestSetDefinition(TestSetDefinition testSetDefinition) {
        repository.update(testSetDefinition);
    }

    public <T extends TestSetDefinition> T getTestSetById(String testSetId) {
        TestSetDefinition def = repository.read(testSetId);
        if (def == null) {
            throw new NotFoundException(testSetId);
        }
        return (T) def;
    }

    public Collection<TestSetDefinition> findTestSets() {
        SearchParameters query = new SearchParameters().setType(valueOf(TestSetDefinition.class));
        return repository.listEntities(query);
    }
}
