package com.xebialabs.xltest.serialize;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class CiListJsonMessageBodyWriter implements MessageBodyWriter<Collection<ConfigurationItem>> {

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];
        }

        return ConfigurationItem.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Collection<ConfigurationItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<ConfigurationItem> cis, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders,
                        OutputStream entityStream) throws IOException, WebApplicationException {

        ConfigurationItemConverter converter = new ConfigurationItemConverter();
        CiWriter writer = new CiJsonWriter();

        writer.startList();
        for (ConfigurationItem ci : cis) {
            converter.writeCi(ci, writer);
        }
        writer.endList();

        entityStream.write(writer.toString().getBytes());
    }

}
