package com.xebialabs.xltest.serialize;

import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
public class EventReader extends BasicMessageBodyReader<Event> {

    Logger LOG = LoggerFactory.getLogger(EventReader.class);

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return Event.class.isAssignableFrom(aClass);
    }


    @Override
    public Event readJson(String json) throws JSONException {
        LOG.debug("Reading event: " + json);
        Map<String, Object> object = (Map<String, Object>) JsonProviderFactory.createProvider().parse(json);
        String type = (String) object.get("type");
        return new Event(type != null ? type : Event.UNKNOWN_EVENT_TYPE, object);
    }
}
