/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRunId;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Metadata(description="Text store base type", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class TextStore
extends Store {
    @Property(description="filename to which records are appended, e.g. myeventstore.log")
    private String filename;
    @Property(description="format of a line in the file using properties of the Record, e.g. \"${starttime} ${testcase} ${right} ${wrong}\"")
    private String format;

    public TextStore() {
    }

    public TextStore(String filename, String format) {
        this.filename = filename;
        this.format = format;
    }

    @Override
    public void store(Event event) {
        String line = this.format(event.getProperties()) + "\n";
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(this.filename, true));
            output.append(line);
            ((Writer)output).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Event> getEventsOfRun(TestRunId runId) {
        return new ArrayList<Event>();
    }

    @Override
    public List<Event> getEventsOfRun(TestRunId runId, Map queryParameters) {
        return new ArrayList<Event>();
    }

    private String format(Map<String, Object> properties) {
        try {
            Template t = new Template("name", (Reader)new StringReader(this.format), new Configuration());
            StringWriter sw = new StringWriter();
            t.process(properties, (Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        catch (TemplateException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

