/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api.xml;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.jboss.resteasy.annotations.Decorator;
import org.jboss.resteasy.spi.interception.DecoratorProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Decorator(processor=Processor.class, target=Marshaller.class)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
@Inherited
public @interface OmitXmlPreamble {

    public static class Processor
    implements DecoratorProcessor<Object, OmitXmlPreamble> {
        private static final Logger logger = LoggerFactory.getLogger(Processor.class);

        public Object decorate(Object target, OmitXmlPreamble annotation, Class type, Annotation[] annotations, MediaType mediaType) {
            if (!(target instanceof Marshaller)) {
                return target;
            }
            try {
                ((Marshaller)target).setProperty("jaxb.fragment", (Object)true);
                logger.trace("Omitting XML Preamble");
                return target;
            }
            catch (PropertyException ignored) {
                return target;
            }
        }
    }
}

