/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xltest.domain.DerbySQLStore;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.Store;
import com.xebialabs.xltest.domain.TestRunId;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="SQL store", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true)
public class SQLStore
extends Store {
    private static final Logger LOG = LoggerFactory.getLogger(DerbySQLStore.class);
    private static final String RUN_ID_FIELD = "run_id";
    @Property(description="connection URL, e.g. jdbc:mysql://localhost/test or jdbc:derby:memory:test or jdbc:db2://sysmvs1.stl.ibm.com:5021/san_jose or jdbc:oracle:thin:@//localhost:1521/orcl")
    private String url;
    @Property(description="Username")
    private String username;
    @Property(description="Password", password=true)
    private String password;
    @Property(description="Tablename")
    private String tablename;
    @Property(description="Property to type map. Contains event property as key (e.g. startTime) and type as value (e.g. DATE)")
    private Map<String, String> propertyTypeMap;

    public SQLStore() {
    }

    public SQLStore(String url, String username, String password, String tablename) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.tablename = tablename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void store(Event event) throws SQLException {
        Connection connection = null;
        try {
            connection = this.createConnection();
            this.createTableIfItDoesNotExist(connection);
            this.insertRow(connection, event);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    public List<Event> getEventsOfRun(TestRunId runId) {
        Connection connection = null;
        try {
            connection = this.createConnection();
            List<Event> list = this.queryEventsForTestRun(connection, runId);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to get events for test run " + runId, e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private Set<String> getColumnNames(ResultSet rs) throws SQLException {
        TreeSet<String> columnNames = new TreeSet<String>();
        ResultSetMetaData meta = rs.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            columnNames.add(meta.getColumnName(i));
        }
        return columnNames;
    }

    private List<Event> queryEventsForTestRun(Connection connection, TestRunId runId) {
        LOG.info("Searching for events for run {}", (Object)runId);
        LinkedList<Event> events = new LinkedList<Event>();
        PreparedStatement statement = null;
        try {
            String query = "select * from " + this.tablename + " where \"" + RUN_ID_FIELD + "\" = ?";
            LOG.info("Query is: {}", (Object)query);
            statement = connection.prepareStatement(query);
            statement.setString(1, runId.toString());
            ResultSet rs = statement.executeQuery();
            Set<String> columnNames = this.getColumnNames(rs);
            LOG.info("Creating events with keys: {}", columnNames);
            while (rs.next()) {
                TreeMap<String, Object> properties = new TreeMap<String, Object>();
                for (String columnName : columnNames) {
                    properties.put(columnName, rs.getObject(columnName));
                }
                if (!properties.containsKey("type")) {
                    properties.put("type", "event");
                }
                LOG.info("Have event: " + properties);
                events.add(new Event(properties));
            }
        }
        catch (SQLException e) {
            LOG.info("Could not retrieve events from table: {}", (Object)e.getMessage());
            this.closeStatement(statement);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfItDoesNotExist(Connection connection) {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.createTableDefinitionString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRow(Connection connection, Event enrichedEvent) {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.createInsertIntoTableString(enrichedEvent));
            int i = 1;
            for (String key : this.getOrderedKeys()) {
                String type = this.getPropertyTypeMap().get(key);
                Object plainColumnValue = enrichedEvent.get(key);
                if (type.equals("int")) {
                    if (plainColumnValue != null) {
                        statement.setInt(i++, (Integer)plainColumnValue);
                        continue;
                    }
                    statement.setNull(i++, 4);
                    continue;
                }
                if (type.startsWith("varchar")) {
                    if (plainColumnValue != null) {
                        statement.setString(i++, plainColumnValue.toString());
                        continue;
                    }
                    statement.setNull(i++, 12);
                    continue;
                }
                if (type.equals("timestamp")) {
                    if (plainColumnValue != null) {
                        statement.setTimestamp(i++, new Timestamp(((Number)plainColumnValue).longValue()));
                        continue;
                    }
                    statement.setNull(i++, 93);
                    continue;
                }
                throw new RuntimeException("Can't build insert row query for type: " + type);
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String createInsertIntoTableString(Event event) {
        throw new RuntimeException("The createInsertIntoTableString method MUST be overridden in subclasses");
    }

    public String columnDefinitionsAsString() {
        throw new RuntimeException("The method columnDefinitionsAsString MUST be overridden in sub class");
    }

    public String makeQuestionMarks() {
        String columnValues;
        StringBuilder sb = new StringBuilder();
        if (!this.getPropertyTypeMap().keySet().isEmpty()) {
            for (int i = 0; i < this.getOrderedKeys().size(); ++i) {
                sb.append("?, ");
            }
        }
        if ((columnValues = sb.toString()).length() > 2) {
            columnValues = columnValues.substring(0, columnValues.length() - 2);
        }
        return columnValues;
    }

    private String createTableDefinitionString() {
        return "create table " + this.getTablename() + this.createColumnDefinitionsAsString();
    }

    public String createColumnDefinitionsAsString() {
        throw new RuntimeException("The method createColumnDefinitionsAsString MUST be overridden in a subtype");
    }

    private Connection createConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        connection.setAutoCommit(true);
        return connection;
    }

    private void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void closeStatement(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getOrderedKeys() {
        ArrayList<String> orderedKeys = new ArrayList<String>();
        orderedKeys.addAll(this.getPropertyTypeMap().keySet());
        Collections.sort(orderedKeys);
        return orderedKeys;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public Map<String, String> getPropertyTypeMap() {
        return this.propertyTypeMap;
    }

    public void setPropertyTypeMap(Map<String, String> propertyTypeMap) {
        this.propertyTypeMap = propertyTypeMap;
    }
}

