/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.repository.ScriptExecutor;
import com.xebialabs.xltest.repository.ScriptExecutorHolder;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.slf4j.LoggerFactory;

@Metadata(virtual=true)
public class ScriptedConfigurationItem
extends BaseConfigurationItem {
    @Property(description="location of the script on the class path", required=false)
    private String scriptLocation;
    private transient StringWriter executionLog;

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(ScriptContext scriptContext) throws ScriptExecutionException, FileNotFoundException {
        this.executionLog = new StringWriter();
        ResultHolder resultHolder = new ResultHolder();
        scriptContext.setAttribute("resultHolder", resultHolder, 100);
        ScriptExecutor executor = ScriptExecutorHolder.getScriptExecutor();
        if (executor == null) {
            throw new IllegalStateException("Script execution has not been initialized");
        }
        scriptContext.setWriter(this.executionLog);
        scriptContext.setErrorWriter(this.executionLog);
        try {
            String scriptPrelude = this.getScriptPrelude();
            if (scriptPrelude != null) {
                executor.evalScript(scriptPrelude, scriptContext);
            }
            executor.evalScriptedCi((ConfigurationItem)this, scriptContext);
        }
        finally {
            LoggerFactory.getLogger((String)this.getType().toString()).info("Script executed, result: {}", resultHolder.result);
            LoggerFactory.getLogger((String)this.getType().toString()).info("Script executed, log: {}", (Object)this.executionLog.toString());
        }
        return (T)resultHolder.result;
    }

    protected ScriptContext getScriptContext() {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setAttribute("self", (Object)this, 100);
        return context;
    }

    protected String getScriptPrelude() {
        return null;
    }

    public String getExecutionLog() {
        return this.executionLog.toString();
    }

    public static class ProcessHolder<T> {
        private T process;

        public void setProcess(T process) {
            this.process = process;
        }

        public T getProcess() {
            return this.process;
        }
    }

    public static class ResultHolder<T> {
        private T result;

        public void setResult(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }
}

