package com.xebialabs.xltest;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.repository.ScriptExecutor;
import com.xebialabs.xltest.repository.ScriptExecutorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.RepositoryException;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class DemoData {
    private Logger LOG = LoggerFactory.getLogger(DemoData.class);

    public void provision(Object elasticSearchBooter, RepositoryService repositoryService) {
        try {
            setUpInitialData(repositoryService, elasticSearchBooter);
        } catch (RepositoryException e) {
            LOG.warn("Unable to fully provision XL Test", e);
        }
    }

    private void setUpInitialData(RepositoryService repositoryService, Object elasticSearchBooter) throws RepositoryException {
        if (demoDataHasBeenLoadedAlready(repositoryService)) {
            return;
        }
        try {
            initDirectoriesInRepository(repositoryService);
            initDemoData(repositoryService, elasticSearchBooter);
        } catch (ScriptExecutionException e) {
            throw new RepositoryException("Could not set up a basic configuration", e);
        } catch (FileNotFoundException e) {
            throw new RepositoryException("Could not set up a basic configuration", e);
        }
    }

    private boolean demoDataHasBeenLoadedAlready(RepositoryService jcrRepositoryService) {
        return jcrRepositoryService.exists("Configuration/TestSpecifications");
    }

    private Directory directory(String path) {
        Directory dir = new Directory();
        dir.setId(path);
        return dir;
    }

    private void initDirectoriesInRepository(RepositoryService repositoryService) {
        repositoryService.createOrUpdate(
                directory("Configuration/Reports"),
                directory("Configuration/Hosts"),
                directory("Configuration/TestSpecifications"),
                directory("Configuration/Dashboards"),
                directory("Configuration/TestExecutors"));
    }

    private void initDemoData(RepositoryService repositoryService, Object elasticSearchBooter) throws ScriptExecutionException, FileNotFoundException {
        ScriptExecutor executor = ScriptExecutorHolder.getScriptExecutor();
        ScriptContext scriptContext = new SimpleScriptContext();
        PrintWriter executionLog = new PrintWriter(new ScriptedConfigurationItem.LogWriter("DemoData"));
        scriptContext.setWriter(executionLog);
        scriptContext.setErrorWriter(executionLog);

        try {
            scriptContext.setAttribute("repository", repositoryService, ScriptContext.ENGINE_SCOPE);
            scriptContext.setAttribute("logger", LoggerFactory.getLogger("Script"), ScriptContext.ENGINE_SCOPE);
            scriptContext.setAttribute("client", elasticSearchBooter, ScriptContext.ENGINE_SCOPE);
            executor.evalScriptFile("demodata/generate.py", scriptContext);
        } finally {
            executionLog.close();
        }
    }

}
