package com.xebialabs.xltest.domain;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.Globbit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.util.*;

public abstract class BaseTestTool implements TestTool{
    private final Logger logger;

    public BaseTestTool() {
		super();
        logger = LoggerFactory.getLogger(this.getClass());
	}

    protected LocalFile retrieveFiles(OverthereFile remoteFile) {
        LocalFile tempFolder = null;
        try {
            if (remoteFile instanceof LocalFile) {
                return ((LocalFile) remoteFile);
            }
            tempFolder = getLocalTempFolder();
            logger.info("Will copy files from {} to {}", remoteFile, tempFolder);
            remoteFile.copyTo(tempFolder);
            logger.info("Copied FitNesseRoot to {}", tempFolder);
            return tempFolder;
        } finally {
            if (tempFolder != null) tempFolder.getConnection().close();
        }
    }

    private LocalFile getLocalTempFolder() {
        File tempFile;
        try {
            tempFile = File.createTempFile("xltesttool", "");
        } catch (IOException e) {
            throw new RuntimeException("Unable to create temp file", e);
        }
        tempFile.delete();
        tempFile.mkdirs();
        LocalConnection localConnection = new LocalConnection(LocalConnection.LOCAL_PROTOCOL, new ConnectionOptions());
        return new LocalFile(localConnection, tempFile);
    }

    @Override
    public Collection<OverthereFile> findTestResultPaths(FileMatcher pattern) {
		return new Globbit().find(pattern);
	}

    protected final Collection<OverthereFile> globbit(OverthereFile file, FileMatcher fileMatcher) {
        return new Globbit().find(fileMatcher);
    }

}