package com.xebialabs.xltest.domain;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.script.ScriptContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.repository.TestRunsRepository;

@SuppressWarnings("serial")
@Metadata(description = "Report base type", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Report extends ScriptedConfigurationItem  implements Computable<TestRun, Object> {
	private static final Logger LOG = LoggerFactory.getLogger(Report.class);

    @Property(description = "The type of report. One of 'link', 'highchart', 'table', 'html', 'qualification'")
    private String reportType;
    
    @Property(description = "The name of the file holding the icon for this report")
    private String iconName;
    
    @Property(description = "The explanation for first time users as shown in the UI")
    private String userFriendlyDescription;
    
    @Property(description = "Optional. When set, this report can only be selected when a TestSpecification's TestToolName is in this list")
    private List<String> applicableTools;

    @Autowired
    private transient RepositoryService repository;
    @Autowired
    private transient TestRunsRepository testRunsRepository;

    private Map<String, Object> attributes = new TreeMap();

    public Report(){
	}

    public String getReportType() {
        return reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getIconName() {
		return iconName;
	}

	public void setIconName(String iconName) {
		this.iconName = iconName;
	}

	public String getUserFriendlyDescription() {
		return userFriendlyDescription;
	}

	public void setUserFriendlyDescription(String userFriendlyDescription) {
		this.userFriendlyDescription = userFriendlyDescription;
	}

	public List<String> getApplicableTools() {
		return applicableTools;
	}

	public void setApplicableTools(List<String> applicableTools) {
		this.applicableTools = applicableTools;
	}

	public TestRunsRepository getTestRunsRepository() {
        return testRunsRepository;
    }

    @Override
    public Object compute(TestRun testRun) {
        ScriptContext context = newScriptContext();
        for (String key : attributes.keySet()) {
            context.setAttribute(key, attributes.get(key), ScriptContext.ENGINE_SCOPE);
        }
        context.setAttribute("testRun", testRun, ScriptContext.ENGINE_SCOPE);
        context.setAttribute("testRuns", testRunsRepository, ScriptContext.ENGINE_SCOPE);
        context.setAttribute("repository", repository, ScriptContext.ENGINE_SCOPE);
        try {
            LOG.debug("About to generate report");
            Object result = execute(context, this);
            return result;
        } catch (Exception e) {
            throw new RuntimeException("Could not perform report transformation.", e);
        }
    }

	public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

	public <T> T getAttribute(String key) {
        return (T) this.attributes.get(key);
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }

    protected RepositoryService getRepository() {
        return repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }
}
