package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

@SuppressWarnings("serial")
@Metadata(description = "A component in a dashboard that holds a report", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class ReportHolder extends BaseConfigurationItem {

	@Property(description = "report held by this holder")
	private Report report;
	
	@Property(description = "x coordinate of this holder on the 12x12 dashboard grid. 0 is left")
	private int x;
	@Property(description = "y coordinate of this holder on the 12x12 dashboard grid. 0 is top")
	private int y;
	@Property(description = "width of this holder on the 12x12 dashboard grid")
	private int w;
	@Property(description = "height of this holder on the 12x12 dashboard grid")
	private int h;

    @Property(isTransient = true)
    private String url;
    @Property(isTransient = true)
    private boolean showCaseData;

    public ReportHolder() {
    }

    public ReportHolder(String id, int x, int y, int w, int h) {
        setId(id);
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public Report getReport() {
		return report;
	}
	public void setReport(Report report) {
		this.report = report;
	}
	public int getX() {
		return x;
	}
	public void setX(int x) {
		this.x = x;
	}
	public int getY() {
		return y;
	}
	public void setY(int y) {
		this.y = y;
	}
	public int getW() {
		return w;
	}
	public void setW(int w) {
		this.w = w;
	}
	public int getH() {
		return h;
	}
	public void setH(int h) {
		this.h = h;
	}

    public String getUrl() {
        return url;
    }

    public void setTestRunId(String testRunId) {
        this.url = testRunId + "/" + report.getId();
    }

    public void setShowCaseData(boolean showCaseData) {
        this.showCaseData = showCaseData;
    }
}
