package com.xebialabs.xltest.domain;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.ws.rs.core.UriBuilder;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.xltest.service.EventRepository;


@SuppressWarnings({"serial", "SpringJavaAutowiredMembersInspection"})
public class TestRun  {

    private final UUID testRunId;
    private String testSpecificationName;
    private String uri;
    private Date startTime;
    private Date finishedTime;
    private boolean qualificationResult;
    private String failureReason;
    private EventRepository eventRepository;

    public TestRun(UUID testRunId) {
        this.testRunId = testRunId;
    }

    public UUID getTestRunId() {
        return testRunId;
    }

    public String getId() {
        return testRunId.toString();
    }

    public String getTestSpecificationName() {
        return testSpecificationName;
    }

    public void setTestSpecificationName(String testSpecificationName) {
        this.testSpecificationName = testSpecificationName;
    }
    
    public void setEventRepository(EventRepository eventRepository) {
    	this.eventRepository = eventRepository;
    }

    public URI getUri() {
        return UriBuilder.fromUri(uri).build();
    }

    public void setUri(URI uri) {
        this.uri = uri.toString();
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public boolean isFinished() {
        return finishedTime != null;
    }

    public boolean getQualificationResult() {
		return qualificationResult;
	}

	public void setQualificationResult(boolean qualificationResult) {
		this.qualificationResult = qualificationResult;
	}
	
	public String getFailureReason() {
		return failureReason;
	}

	public void setFailureReason(String failureReason) {
		this.failureReason = failureReason;
	}

	public List<Event> getEvents(Map queryParameters, final String sortingProperty) {
		// e.g. sortingProperty == 'pageName' then order all event alfabetically on value of that property (String only)
    	List<Event> events = getEvents(queryParameters);
        return sortEvents(events, sortingProperty);
    }

	private List<Event> sortEvents(List<Event> events, final String sortingProperty) {
		List<Event> filteredEvents = Lists.newArrayList(Iterables.filter(events, new Predicate<Event>() {
            @Override
            public boolean apply(Event e) {
                return e.hasProperty(sortingProperty) && e.get(sortingProperty) instanceof Comparable;
            }
        }));

		Collections.sort(filteredEvents, new Comparator<Event>() {
			@Override
			public int compare(Event o1, Event o2) {
                String s1 = o1.get(sortingProperty);
                String s2 = o2.get(sortingProperty);
                return s1.compareTo(s2);
			}});
		return filteredEvents;
	}

	public List<Event> getEvents(Map queryParameters) {
    	String query = constructQuery(testRunId, queryParameters);
    	return eventRepository.query(query);
    }
	
	private String constructQuery(UUID runId, Map queryParameters) {
        return constructSearchQuery("runId:\"" + runId + "\"", queryParameters);
    }
	
	private String constructSearchQuery(String query, Map queryParameters) {
        for (Object key : queryParameters.keySet()) {
            String value = (String) queryParameters.get(key);
            query = query + " AND " + key + ":\"" + value + "\"";
        }
        return query;
    }

    public List<Event> getEvents() {
    	String query = constructQuery(testRunId, Collections.emptyMap());
    	return eventRepository.query(query);
    }

	private String getStartDay() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(this.startTime);
	}

}
