package com.xebialabs.xltest.resources;

import java.io.PrintWriter;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.serialize.ListOfEventsWriter;

@Controller
@Path("/test")
@Produces("text/event-stream")
public class EventFeedController {
    private static final Logger LOG = LoggerFactory.getLogger(EventFeedController.class);
    private final TestRunsRepository testRunsRepository;
    private final ListOfEventsWriter serializer = new ListOfEventsWriter();

    @Autowired
    public EventFeedController(TestRunsRepository testRunsRepository) {
        this.testRunsRepository = testRunsRepository;
    }

    @GET
    @Path("/{taskId:.+}")
    public void getTestRun(@PathParam("taskId") String taskId, @Context HttpServletResponse response) throws Exception {
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Connection", "keep-alive");

        final PrintWriter writer = response.getWriter();

        TestRun testRun = testRunsRepository.getTestRun(UUID.fromString(taskId));
        for (Event event : testRun.getEvents()) {
            sendEvent(event, writer);
        }

        // TODO: We need something until we can manage the response connection ourselves.
        while (!testRun.isFinished()) {
            Thread.sleep(1000);
        }

        closeEventStream(writer);
    }

    private void sendEvent(Event event, PrintWriter writer) throws JSONException {
        writer.write("event: event\n");
        writer.write("data: " + serializer.toJson(event) + "\n\n");
        writer.flush();
    }

    private void closeEventStream(PrintWriter writer) {
        writer.write("event: close\n");
        writer.write("data: \n\n");
        writer.close();
    }

}
