package com.xebialabs.xltest.resources;

import static com.xebialabs.deployit.plugin.api.reflect.Type.valueOf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.repository.TestTools;

@Controller
@Path("/hosts")
@Produces(MediaType.APPLICATION_JSON)
public class HostController {
	private static final Logger LOG = LoggerFactory.getLogger(HostController.class);

	private final RepositoryService repositoryService;
	private final TestTools testTools;
    private final TestRunsRepository testRunsRepository;

    @Autowired
	public HostController(RepositoryService repositoryService, TestTools testTools, TestRunsRepository testRunsRepository) {
		this.repositoryService = repositoryService;
        this.testTools = testTools;
        this.testRunsRepository = testRunsRepository;
    }

	@GET
    @Path("/")
    public String treeForHost() throws JSONException {
		SearchParameters query = new SearchParameters().setType(valueOf(Host.class));
        List<Host> allHosts = repositoryService.listEntities(query);
        if (allHosts == null) {
        	allHosts = Collections.emptyList();
        }
        query = new SearchParameters().setType(valueOf(BaseTestSpecification.class));
        List<BaseTestSpecification> allTestSpecifications = repositoryService.listEntities(query);
		return createHostTree(allHosts, allTestSpecifications).toString();
    }
	
	protected JSONArray createHostTree(List<Host> allHosts, List<BaseTestSpecification> allTestSpecifications) throws JSONException {
		JSONArray jArray = new JSONArray();
		for (Host host : allHosts) {
			JSONObject child = new JSONObject();
			child.put("name", host.getName());
			child.put("type", host.getType());
			List<BaseTestSpecification> testSpecificationsUsingHost = getTestSpecificationsUsingHost(host.getId(), allTestSpecifications);
			if (testSpecificationsUsingHost != null) {
				child.put("testSpecifications", createTestSpecificationList(testSpecificationsUsingHost));
			}
            jArray.put(child);
        }
		return jArray;
	}
	
	protected JSONArray createTestSpecificationList(List<BaseTestSpecification> testSpecifications) throws JSONException {
		JSONArray jArray = new JSONArray();
		for (BaseTestSpecification testSpecification : testSpecifications) {
			JSONObject child = new JSONObject();
			child.put("name", testSpecification.getName());
			child.put("type", testSpecification.getType());
            jArray.put(child);
        }
		return jArray;
	}

	private List<BaseTestSpecification> getTestSpecificationsUsingHost(String hostId, List<BaseTestSpecification> allTestSpecifications) {
		List<BaseTestSpecification> testSpecifications = new ArrayList<BaseTestSpecification>();
		for (BaseTestSpecification  testSpecification : allTestSpecifications) {
			if (testSpecification.hasProperty("host") && (((Host)testSpecification.getProperty("host")).getId()).equals(hostId)) {
				testSpecifications.add(testSpecification);
			}
		}
		return testSpecifications;
	}

}
