package com.xebialabs.xltest.resources;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.TestRun;



@Controller
@Path("/rerun")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class RerunController {
	private static final Logger LOG = LoggerFactory.getLogger(RerunController.class);
	
    private final RepositoryService repository;

    @Autowired
    public RerunController(RepositoryService repository) {
        this.repository = repository;
    }
    
	@GET
	@Path("{testRunId:[\\w-]+}")
	public Response rerunSlice(@PathParam("testRunId") String testRunId, @HeaderParam("xltest-base") String xlTestBase, @Context final UriInfo uriInfo)
			throws IOException, InterruptedException {
//		LOG.info("Attempting to re-run test run {}", testRunId);
//		TestRun oldRun = findOldRun(testRunId);
//		Type runType = oldRun.getType();
//		TestRun testRun = runType.getDescriptor().newInstance("");
//		Collection<PropertyDescriptor> propertyDescriptors = runType.getDescriptor().getPropertyDescriptors();
//		for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
//			String propertyName = propertyDescriptor.getName();
//			testRun.setProperty(propertyName, oldRun.getProperty(propertyName));
//		}
//		TestRun newRun = fireTest(testRun, xlTestBase, uriInfo);
//		String newRunId = newRun.getName();
		URI location = URI.create("#/testruns/" + "");
		return Response.temporaryRedirect(location).build();
	}
    
//	public TestRun fireTest(final TestRun testRun, String xlTestBase, UriInfo uriInfo) throws IOException, InterruptedException {
//        URI xlTestBaseUri;
//        if (xlTestBase != null) {
//            xlTestBaseUri = URI.create(xlTestBase + "/test");
//        } else {
//            xlTestBaseUri = uriInfo.getAbsolutePath();
//            int firstIndexOfSlash = xlTestBaseUri.toString().indexOf("/");
//            if (xlTestBaseUri.toString().length() > firstIndexOfSlash + 1) {
//            	String firstPart = xlTestBaseUri.toString().substring(0, firstIndexOfSlash);
//            	xlTestBaseUri = URI.create(firstPart + "/test");
//            }
//        }
//        return testRunner.run(testRun, xlTestBaseUri);
//	}

}

