package com.xebialabs.xltest.serialize;

import com.google.common.base.Strings;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.view.ExecutionParameters;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
public class ExecutionParametersReader extends BasicMessageBodyReader<ExecutionParameters> {

    Logger LOG = LoggerFactory.getLogger(ExecutionParametersReader.class);

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return ExecutionParameters.class.isAssignableFrom(aClass);
    }


    @Override
    public ExecutionParameters readJson(String json) throws JSONException {
        if (Strings.isNullOrEmpty(json)) {
            return new ExecutionParameters(null, null, null);
        }
        Map<String, Object> object = (Map<String, Object>) JsonProviderFactory.createProvider().parse(json);

        String commandLine = (String) object.get("commandLine");
        String hostId = (String) object.get("hostId");
        Map<String, String> parameters = (Map<String, String>) object.get("parameters");
        return new ExecutionParameters(commandLine, hostId, parameters);
    }
}
