package com.xebialabs.xltest.utils;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JsonResponseParser implements ResponseParser {

    private final JsonProvider jsonProvider;
    private Object json;
	
	private static final Logger LOG = LoggerFactory.getLogger(JsonResponseParser.class.getName());

    public JsonResponseParser() {
        jsonProvider = JsonProviderFactory.createProvider();
    }

    @Override
	public void parse(final String content) {
        json = jsonProvider.parse(content);
	}

    public JsonProvider getJsonProvider() {
        return jsonProvider;
    }

    public boolean isMap() {
        return jsonProvider.isMap(json);
    }
    @Override
	public Object getValue(final String path) {
        return JsonPath.read(json, path);
	}

    @Override
    public int getCount(final String path) {
         Object results = JsonPath.read(json, path);
         if (results instanceof JSONArray) {
             return ((JSONArray) results).size();
         } else if (results instanceof JSONObject) {
             return ((JSONObject) results).size();
         }
         return results != null ? 1 : 0;
    }

    @Override
    public String acceptedMimeType() {
        return "application/json";
    }
}
