package com.xebialabs.xltest.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.xebialabs.overthere.OverthereFile;

public class PatternBasedFileMatcher {
	
	private String prefix;
    
    public PatternBasedFileMatcher(String prefix) {
        super();
        this.prefix = prefix;
    }

    public List<OverthereFile> getFilesToCopy(OverthereFile startDirectory) {
    	List<OverthereFile> results = new ArrayList<OverthereFile>();
    	for (OverthereFile file : startDirectory.listFiles()) {
    		if (file.isDirectory()) {
    			if (matches(file.getName(), prefix)) {
    				results.add(file);
    			} else {
    				results.addAll(getFilesToCopy(file));
    			}
    		} else {
    			if (matches(file.getName(), prefix)) {
    				results.add(file);
    			}
    		}
    	}
    	return results;
	}

	private boolean matches(String name, String prefix) {
		Pattern p = Pattern.compile(prefix);
		Matcher m = p.matcher(name);
		return m.matches();
	}

}
