package com.xebialabs.xltest.utils.glob;

import com.google.common.base.Strings;
import com.xebialabs.overthere.OverthereFile;
import org.springframework.util.AntPathMatcher;

import java.util.Date;

public class FileMatcher {

    private OverthereFile searchRoot;

    private String syntaxAndPattern;

    private Date lastModifiedDateAfter;

    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public FileMatcher(OverthereFile searchRoot, String pattern) {
        this.searchRoot = searchRoot;
        this.syntaxAndPattern = searchRoot.getPath() + searchRoot.getConnection().getHostOperatingSystem().getFileSeparator() + pattern;
    }

    public FileMatcher withLastModifiedDateAfter(Date modifiedDate) {
        this.lastModifiedDateAfter = modifiedDate;
        return this;
    }

    public boolean match(OverthereFile file) {
        boolean matched = true;

        if(!Strings.isNullOrEmpty(syntaxAndPattern)) {
            matched = matched && pathMatcher.match(syntaxAndPattern, file.getPath());
        }
        if(lastModifiedDateAfter != null) {
            matched = matched && file.lastModified() > lastModifiedDateAfter.getTime();
        }
        return matched;
    }

    public OverthereFile getSearchRoot() {
        return searchRoot;
    }

}
