package com.xebialabs.xltest.utils.glob;

import com.xebialabs.overthere.OverthereFile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Globbit {


    public Collection<OverthereFile> find(FileMatcher fileMatcher) {
        return matchingFiles(fileMatcher.getSearchRoot(), fileMatcher);
    }

    public Collection<OverthereFile> find(OverthereFile file, String pattern) {
        return matchingFiles(file, new FileMatcher(file, pattern));
    }

    private List<OverthereFile> matchingFiles(OverthereFile file, FileMatcher matcher) {
		List<OverthereFile> all = new ArrayList<>();
		if (file.exists()) {
            if (matcher.match(file)) {
                all.add(file);
			} else if (file.isDirectory()) {
				for (OverthereFile child: file.listFiles()) {
					all.addAll(matchingFiles(child, matcher));
				}
			}
		}
		return all;
	}

}
