package com.xebialabs.xltest.view;

import com.google.common.base.Strings;

import java.util.Map;

public class ExecutionParameters {
    private final String commandLine;
    private final String hostId;
    private final Map<String, String> parameters;

    public ExecutionParameters(String commandLine, String hostId, Map<String, String> parameters) {
        this.commandLine = commandLine;
        this.hostId = hostId;
        this.parameters = parameters;
    }

    public String getCommandLine() {
        return commandLine;
    }

    public String getHostId() {
        return hostId;
    }

    public Map<String, String> getParameters() {
        return parameters;
    }

    public boolean isEmpty() {
        return parameters == null;
    }

    public boolean satisfies(ExecutionParameterRequest request) {
        if (!isExecutable() && !request.isExecutable()) return false;
        if (request.hasParameters()) {
            return parameters != null;
        }
        return true;
    }

    public boolean isExecutable() {
        return !Strings.isNullOrEmpty(commandLine) && hostId != null;
    }

}
