#!/usr/bin/env python


FITNESSE_TEST_SPEC_NAME = 'demoFitNesse'
CUCUMBER_TEST_SPEC_NAME = 'demoCucumber'
GATLING_TEST_SPEC_NAME = 'demoGatling'

import time, urllib2, uuid, os, os.path, platform, stat, glob
from pprint import pprint
from net.minidev.json import JSONObject
from com.xebialabs.deployit.plugin.api.reflect import DescriptorRegistry, Type
from java.lang import Thread, System
from java.util import UUID
from java.io import File, InputStreamReader, BufferedReader
from com.xebialabs.overthere.local import LocalConnection, LocalFile
from com.xebialabs.xltest.domain import EventHandler, Event, Qualifier
from com.xebialabs.xltest.cucumber import CucumberTestTool
from com.xebialabs.xltest.utils.glob import FileMatcher
import com.xebialabs.xltest.domain.TestSpecification as TestSpecificationConst

Report = DescriptorRegistry.getDescriptor(Type.valueOf("generic.Report")).newInstance
Qualification = DescriptorRegistry.getDescriptor(Type.valueOf("generic.Qualification")).newInstance
BarChart = DescriptorRegistry.getDescriptor(Type.valueOf("generic.Chart")).newInstance
PieChart = DescriptorRegistry.getDescriptor(Type.valueOf("generic.Chart")).newInstance
Details = DescriptorRegistry.getDescriptor(Type.valueOf("freemarker.ReportWithHistory")).newInstance
DeprecatedOldDuration = DescriptorRegistry.getDescriptor(Type.valueOf("freemarker.ReportWithHistory")).newInstance
Durations = DescriptorRegistry.getDescriptor(Type.valueOf("demo.DurationsReport")).newInstance
GatlingRequestsOverviewChart = DescriptorRegistry.getDescriptor(Type.valueOf("generic.Chart")).newInstance
ReportHolder = DescriptorRegistry.getDescriptor(Type.valueOf("generic.ReportHolder")).newInstance
Dashboard = DescriptorRegistry.getDescriptor(Type.valueOf("generic.Dashboard")).newInstance
LocalHost = DescriptorRegistry.getDescriptor(Type.valueOf("overthere.LocalHost")).newInstance
ExecutableTestSpecification = DescriptorRegistry.getDescriptor(Type.valueOf("generic.ShowCaseTestSpecification")).newInstance

SuperSet = DescriptorRegistry.getDescriptor(Type.valueOf("generic.TestSpecificationSet")).newInstance

# deprecated (use Dashboard instead!)
Composite = DescriptorRegistry.getDescriptor(Type.valueOf("demo.CompositeReport")).newInstance


def resourcefile(name):
    loader = Thread.currentThread().getContextClassLoader()
    stream = loader.getResourceAsStream(name)
    # if not stream: raise StopIteration()
    reader = BufferedReader(InputStreamReader(stream))

    try:
        line = reader.readLine()
        yield line
        while line is not None:
            line = reader.readLine()
            yield line
    finally:
        reader.close()



# CONFIFIGURATION ITEMS #################

def store_reports():
    functional_qualification = Qualification()
    functional_qualification.setId("Configuration/Reports/" + TestSpecificationConst.DEFAULT_FUNCTIONAL_TEST_QUALIFIER)
    functional_qualification.setProperty("scriptLocation", "functional/qualification.py")
    repository.createOrUpdate(functional_qualification)
    print 'functional_qualification created'

    performance_qualification = Qualification()
    performance_qualification.setId("Configuration/Reports/" + TestSpecificationConst.DEFAULT_PERFORMANCE_TEST_QUALIFIER)
    performance_qualification.setProperty("scriptLocation", "performance/qualification.py")
    repository.createOrUpdate(performance_qualification)
    print 'performance_qualification created'

    bar = BarChart()
    bar.setId("Configuration/Reports/BarChart")
    bar.setProperty("scriptLocation", "reports/BarChart.py")
    bar.setProperty("iconName", "bar-report-icon")
    bar.setProperty("userFriendlyDescription", "A chart with rectangular bars with lengths proportional to the values the represent. Also known as a 'Histogram'")
    repository.createOrUpdate(bar)
    barPerTeam = BarChart()
    barPerTeam.setId("Configuration/Reports/BarPerTeam")
    barPerTeam.setProperty("scriptLocation", "reports/BarChartPerTeam.py")
    barPerTeam.setProperty("iconName", "bar-report-icon")
    barPerTeam.setProperty("userFriendlyDescription", "A chart with rectangular bars with lengths proportional to the values the represent. One bar per Team. Also known as a 'Histogram'")
    repository.createOrUpdate(barPerTeam)
    multiCucumberBarChart = BarChart()
    multiCucumberBarChart.setId("Configuration/Reports/MultiCucumberBarChart")
    multiCucumberBarChart.setProperty("scriptLocation", "reports/MultiCucumberBarChart.py")
    multiCucumberBarChart.setProperty("iconName", "bar-report-icon")
    multiCucumberBarChart.setProperty("userFriendlyDescription", "A chart with rectangular bars with lengths proportional to the values the represent. Also known as a 'Histogram'")
    multiCucumberBarChart.setProperty("applicableTools", ["Cucumber"])
    repository.createOrUpdate(multiCucumberBarChart)
    pie = PieChart()
    pie.setId("Configuration/Reports/Pie")
    pie.setProperty("scriptLocation", "reports/PieChart.py")
    pie.setProperty("iconName", "pie-report-icon")
    pie.setProperty("userFriendlyDescription", "A circular statistical graphic which is divided into sectors to illustrate numerical proportion. The arc length of each sector is proportional to the quantity it represents")
    repository.createOrUpdate(pie)
    details = Details()
    details.setId("Configuration/Reports/Details")
    details.setProperty("scriptLocation", "reports/details.ftl")
    details.setProperty("reportType", "html")
    details.setProperty("maxRunsInHistory", 10)
    details.setProperty("iconName", "???")
    details.setProperty("userFriendlyDescription", "A table in which each row contains the essential properties of the item displayed in that row")
    repository.createOrUpdate(details)
    composite = Composite()
    composite.setId("Configuration/Reports/Composite")
    composite.setProperty("scriptLocation", "reports/Composite.py")
    composite.setProperty("title", "Overview")
    composite.setProperty("topLeft", bar)
    composite.setProperty("topRight", pie)
    composite.setProperty("bottom", details)
    composite.setProperty("iconName", "???")
    composite.setProperty("userFriendlyDescription", "A composition of a Bar Chart, a Pie Chart and a Details Report");
    repository.createOrUpdate(composite)
    durations = Durations()
    durations.setId("Configuration/Reports/Durations")
    durations.setProperty("scriptLocation", "reports/Durations.py")
    durations.setProperty("reportType", "html")
    durations.setProperty("title", "Test execution duration overview per subsuite")
    durations.setProperty('maxRunsInHistory', 15)
    repository.createOrUpdate(durations)
    deprecatedOldDuration = DeprecatedOldDuration()
    deprecatedOldDuration.setId("Configuration/Reports/DeprecatedOldDurations")
    deprecatedOldDuration.setProperty("scriptLocation", "reports/deprecatedOldDurationdetails.ftl")
    deprecatedOldDuration.setProperty("reportType", "html")
    deprecatedOldDuration.setProperty("maxRunsInHistory", 10)
    deprecatedOldDuration.setProperty("iconName", "???")
    deprecatedOldDuration.setProperty("userFriendlyDescription", "A table in which each row contains the time it took to run a Test. The row also contains average times over the last 10 runs")
    repository.createOrUpdate(deprecatedOldDuration)
    health = Report()
    health.setId("Configuration/Reports/Health barometer")
    health.setProperty("scriptLocation", "reports/HealthBarometer.py")
    health.setProperty("reportType", "health")
    health.setProperty("iconName", "???")
    health.setProperty("userFriendlyDescription", "A composition of Flakiness, Duration Trend and Failures")
    repository.createOrUpdate(health)
    stats = Report()
    stats.setId("Configuration/Reports/General statistics")
    stats.setProperty("scriptLocation", "reports/GeneralStatistics.py")
    stats.setProperty("reportType", "stats")
    stats.setProperty("iconName", "???")
    stats.setProperty("userFriendlyDescription", "Top level overview of the current run compared to the previous run. Shows what changed")
    repository.createOrUpdate(stats)
    gatlingRequestsOverview = GatlingRequestsOverviewChart()
    gatlingRequestsOverview.setId("Configuration/Reports/Load Test Trends")
    gatlingRequestsOverview.setProperty("scriptLocation", "reports/LoadTestTrends.py")
    gatlingRequestsOverview.setProperty("reportType", "performance")
    gatlingRequestsOverview.setProperty("iconName", "trend-report-icon")
    gatlingRequestsOverview.setProperty("userFriendlyDescription", "Trend of the mean response time per request over multiple simulations. Also shows number of OK and not-OK responses in Bar Chart format")
    gatlingRequestsOverview.setProperty("applicableTools", ["Gatling"])
    repository.createOrUpdate(gatlingRequestsOverview)
    flakinessField = Report()
    flakinessField.setId("Configuration/Reports/Flakiness Overview")
    flakinessField.setProperty("scriptLocation", "reports/flakinessField.py")
    flakinessField.setProperty("reportType", "flakinessfield")
    flakinessField.setProperty("iconName", "flakiness-report-icon")
    flakinessField.setProperty("userFriendlyDescription", "A Table showing the most 'Flaky' tests. The more that test changes result over time, the 'flakier' it is. Presented as a percentage.")
    repository.createOrUpdate(flakinessField)


def store_fitNesseTestSpecification():
    testSpecification = ExecutableTestSpecification()
    testSpecification.id = 'Configuration/TestSpecifications/' + FITNESSE_TEST_SPEC_NAME
    testSpecification.setProperty("scriptLocation", "generic/ExecutableTestSpecification.py")
    # 'tags' property is a synthetic, so don't use the dot notation to set it!
    testSpecification.setProperty('tags', 'team8')
    testSpecification.qualification = repository.read("Configuration/Reports/" + TestSpecificationConst.DEFAULT_FUNCTIONAL_TEST_QUALIFIER)
    testSpecification.workingDirectory = '.'
    testSpecification.testToolName = 'FitNesse'
    testSpecification.searchPattern = '**/files/testResults'
    localHost = LocalHost()
    localHost.id = 'Infrastructure/demo Host'
    testSpecification.host = localHost
    os = System.getProperty("os.name").lower()
    testSpecification.commandLine = osSpecificCommand(os, 'java -jar plugins/fitnesse-20140901-standalone.jar') +  ' -p 1234 -c "DemoSuite?suite&debug&format=text&suiteFilter={{tags}}" '
    repository.createOrUpdate(localHost, testSpecification)
    return testSpecification

def osSpecificCommand(os, commandLine):
    if os.rfind("win") >= 0:
        commandLine = commandLine.replace("/", "\\")
        if commandLine.endswith('.sh'):
            commandLine = commandLine.replace(".sh", ".bat")
    return commandLine

def store_TestSpecificationSet(fitNesseTestSpecification, cucumberTestSpecification):
    super = SuperSet()
    super.id = 'Configuration/TestSpecifications/super'
    super.testSpecifications = [fitNesseTestSpecification, cucumberTestSpecification]
    repository.createOrUpdate(super)
    
def store_cucumberTestSpecification():
    testSpecification = ExecutableTestSpecification()
    testSpecification.id = 'Configuration/TestSpecifications/' + CUCUMBER_TEST_SPEC_NAME
    testSpecification.setProperty("scriptLocation", "generic/ExecutableTestSpecification.py")
    os = System.getProperty("os.name").lower()
    if os.rfind("win") >= 0:
        testSpecification.searchPattern = '**\\cucumber-report.json'
    else:
        testSpecification.searchPattern = '**/cucumber-report.json'
    testSpecification.qualification = repository.read("Configuration/Reports/" + TestSpecificationConst.DEFAULT_FUNCTIONAL_TEST_QUALIFIER)
    testSpecification.workingDirectory = '.'
    testSpecification.testToolName = 'Cucumber'
    localHost = LocalHost()
    localHost.id = 'Infrastructure/demo Host'
    testSpecification.host = localHost
    os = System.getProperty("os.name").lower()
    testSpecification.commandLine = osSpecificCommand(os, 'testmaterials/cucumber/startCucumber.sh')
    testSpecification.timeout = 10
    repository.createOrUpdate(localHost, testSpecification)
    return testSpecification

def store_gatlingTestSpecification():
    testSpecification = ExecutableTestSpecification()
    testSpecification.id = 'Configuration/TestSpecifications/' + GATLING_TEST_SPEC_NAME
    testSpecification.setProperty("scriptLocation", "generic/ExecutableTestSpecification.py")
    os = System.getProperty("os.name").lower()
    if os.rfind("win") >= 0:
        testSpecification.searchPattern = '**\\simulation.log'
    else:
        testSpecification.searchPattern = '**/simulation.log'
    testSpecification.qualification = repository.read("Configuration/Reports/" + TestSpecificationConst.DEFAULT_PERFORMANCE_TEST_QUALIFIER)
    testSpecification.workingDirectory = '.'
    testSpecification.testToolName = 'Gatling'
    localHost = LocalHost()
    localHost.id = 'Infrastructure/demo Host'
    testSpecification.host = localHost
    os = System.getProperty("os.name").lower()
    testSpecification.commandLine = osSpecificCommand(os, 'testmaterials/gatling/startGatlingTest.sh')
    testSpecification.timeout = 10
    repository.createOrUpdate(localHost, testSpecification)
    return testSpecification

def store_dashboards():
    # NB create parent (== a directory), then create and save the holders, finally update the parent
    #    this order is required due to the 'asContainment' property of 'reportHolders' which in turn we
    #    need to send the whole parent/child relation to the UI in one go.
    dashboard = Dashboard()
    dashboard.id = 'Configuration/Dashboards/Demo Dashboard'
    dashboard.toolCategories = ["functional"]
    repository.createOrUpdate(dashboard)
    barReportHolder = ReportHolder()
    barReportHolder.id = dashboard.id + '/barReportHolder'
    barReportHolder.x = 0
    barReportHolder.y = 0
    barReportHolder.w = 12
    barReportHolder.h = 8
    barReportHolder.report = repository.read("Configuration/Reports/BarChart")
    healthReportHolder = ReportHolder()
    healthReportHolder.id = dashboard.id + '/healthReportHolder'
    healthReportHolder.x = 0
    healthReportHolder.y = 8
    healthReportHolder.w = 8
    healthReportHolder.h = 4
    healthReportHolder.report = repository.read("Configuration/Reports/Health barometer")
    
    statsReportHolder = ReportHolder()
    statsReportHolder.id = dashboard.id + '/statsReportHolder'
    statsReportHolder.x = 8
    statsReportHolder.y = 8
    statsReportHolder.w = 4
    statsReportHolder.h = 4
    statsReportHolder.report = repository.read("Configuration/Reports/General statistics")
    repository.createOrUpdate(barReportHolder, healthReportHolder, statsReportHolder)
    dashboard.reportHolders = [barReportHolder, healthReportHolder, statsReportHolder]
    repository.createOrUpdate(dashboard)

class MyEventHandler(EventHandler):
    def onReceive(self, event):
        print 'MyEventHandler', event
        extendedEvent = Event(event, {'testSpecification' : CUCUMBER_TEST_SPEC_NAME})
        store_event(extendedEvent.properties)

class MyQualifier(Qualifier):
    def getQualificationResult(self):
        return True
    def update(self, event):
        pass

def import_cucumber(cucumber_runId, cucumberTestSpec):
    # read example json from cucumber plugin
    cucumberTool = CucumberTestTool()
    resultPath = LocalFile(LocalConnection.getLocalConnection(), File("plugins/demo"))
    if resultPath.exists():
    	print 'ResultPath found we are in production mode'
    else:
        print 'ResultPath not found, I will try in src/dist dir'
        resultPath = LocalFile(LocalConnection.getLocalConnection(), File("src/dist/plugins/demo"))
        if resultPath.exists():
            print 'ResultPath found in src/dist dir; we are in dev mode'
        else:
            print 'ResultPath also not found in current working dir either. I give up', resultPath.path
    importables = cucumberTool.findImportables(resultPath, FileMatcher(resultPath, "**/example*json"))
    print 'importables', importables
    for importable in importables:
        print 'importing', importable
        importable.doImport(cucumber_runId, MyEventHandler())
        print 'done importing'

	
# TEST RUNS #######################

def store_event(event):
    data=JSONObject.toJSONString(event)

    if event[Event.TYPE] and event[Event.RUN_ID] and event[Event.TIMESTAMP] and event[Event.TEST_SPECIFICATION]:
        client.insert(event[Event.TYPE], data)
    else:
        raise ValueError, 'Event invalid: ' + data


def iso_time(t):
    return time.strftime("%Y-%m-%dT%H:%M:%S", time.localtime(t))


def coerce(token):
    """
    Try to convert @token to a element in a more natural (parsed) from:

    >>> coerce("Str")
    'Str'
    >>> coerce("20")
    20

    :return:
    """
    try:
        return int(token)
    except ValueError:
        return token


def read_definitions():
    print 'reading definitions'
    import csv
    config = {}
    data = []
    # with open('definitions.csv', 'rb') as csvfile:
    csvfile = resourcefile('demodata/definitions.csv')
    print 'csvfile is', csvfile
    spamreader = csv.reader(csvfile, delimiter=',', quotechar='"')
    print 'csvfile is', csvfile

    mode = 'config'
    for row in spamreader:
        print row
        if not row or len(row) < 2 or not row[1]:
            continue

        # Check on section (column 1)
        if row[0] == 'config:':
            mode = 'config'
        elif row[0] == 'fitnesse:':
            mode = 'fitnesse'
            header = row[1:]
            continue

        # Handle data (column 2+)
        if mode == 'config':
            config[row[1]] = coerce(row[2])
        elif mode == 'fitnesse':
            data.append(dict(zip(header, map(coerce, row[1:]))))

    return config, data


def generate_permutations(definition, runId, timestamp):
    from random import randint
    ratio = 6
    for r in xrange(1, definition['test cases'] + 1):
        result = dict()
        result[Event.RUN_ID] = runId
        result[Event.TYPE] = Event.FUNCTIONAL_RESULT
        result[Event.TEST_SPECIFICATION] = FITNESSE_TEST_SPEC_NAME
        duration = randint(definition['duration'] - definition['dt'], definition['duration'] + definition['dt'])
        result[Event.TIMESTAMP] = int(timestamp) * 1000
        result['duration'] = duration
        timestamp = timestamp + duration
        result['name'] = 'DemoSuite;%s;UseCase%03d;TestCase%03d' % (definition['app name'], r / ratio + 1, r % ratio + 1)
        if randint(0, 100) < definition['fault%']:
            result['wrong'] = randint(1, 2)
            result['right'] = 0
            result['result'] = 'FAILED'
        else:
            result['right'] = randint(2, 3)
            result['wrong'] = 0
            result['result'] = 'PASSED'
        yield result, int(timestamp) + duration

def createFitNesseSuitePageIfNeeded(directory):
    # directory is e.g. FitNesseRoot/DemoSuite/WebApp/UseCase001/TestCase003. Create for 'WebApp', 'UseCase001'
    dir = directory
    while os.path.dirname(dir) != 'FitNesseRoot':
        dir = os.path.dirname(dir)
        file = dir + '/properties.xml'
        if not os.path.exists(file):
            with open(file,"w") as f:
                f.write('<?xml version="1.0"?>\n')
                f.write('<properties>\n')
                f.write('        <Edit/>\n')
                f.write('        <Files/>\n')
                f.write('        <Properties/>\n')
                f.write('        <RecentChanges/>\n')
                f.write('        <Refactor/>\n')
                f.write('        <Search/>\n')
                f.write('        <Suite/>\n')
                f.write('        <Suites></Suites>\n')
                f.write('        <Versions/>\n')
                f.write('        <WhereUsed/>\n')
                f.write('</properties>\n')

        file = dir + '/content.txt'
        if not os.path.exists(file):
            with open(file,"w") as f:
                f.write('!define TEST_SYSTEM {slim}\n')
                f.write('!contents -R2 -g -p -f -h\n')


def createFitNesseTestPage(pageName, result, right, wrong, team):
    directory = 'FitNesseRoot/' + pageName.replace(';','/')
    if not os.path.exists(directory):
        os.makedirs(directory)
    createFitNesseSuitePageIfNeeded(directory)
    file = directory + '/content.txt'
    if result == 'PASSED':
        passFail = 'succeed'
    else:
        passFail = 'fail'
    with open(file,"w") as f:
        f.write('Simple test. Should ' + passFail + ' without extra dependencies.\n')
        f.write('\n')
        f.write('| import |\n')
        f.write('| fitnesse.fixtures |\n')
        f.write('\n')
        f.write('| script | echo fixture |\n')
        if result == 'PASSED':
            for x in xrange(1, right):
                f.write('| check | echo | Hello World | Hello World |\n')
        else:
            for x in xrange(1, wrong):
                f.write('| check | echo | Hello World | Hello Universe |\n')

    file = directory + '/' + 'properties.xml'
    with open(file, "w") as f:
        f.write('<?xml version="1.0"?>\n')
        f.write('<properties>\n')
        f.write('    <Edit>true</Edit>\n')
        f.write('    <Files>true</Files>\n')
        f.write('    <Properties>true</Properties>\n')
        f.write('    <RecentChanges>true</RecentChanges>\n')
        f.write('    <Refactor>true</Refactor>\n')
        f.write('    <Search>true</Search>\n')
        f.write('    <Suites>team%s</Suites>\n' % team)
        f.write('    <Test/>\n')
        f.write('    <Versions>true</Versions>\n')
        f.write('    <WhereUsed>true</WhereUsed>\n')
        f.write('</properties>\n')


def fitnesse_result_event(event_type, runId, timestamp, **kwargs):
    event = dict()
    event[Event.RUN_ID] = runId
    event[Event.TIMESTAMP] = timestamp * 1000
    event[Event.TYPE] = event_type
    event[Event.TEST_SPECIFICATION] = FITNESSE_TEST_SPEC_NAME
    event.update(kwargs)
    return event

def parent_execution_event(event_type, runId, timestamp, **kwargs):
    event = dict()
    event[Event.RUN_ID] = str(runId)
    event[Event.TYPE] = event_type
    event[Event.TIMESTAMP] = timestamp * 1000
    event.update(kwargs)
    return event

def child_execution_started_event(parent_runId, runId, timestamp, **kwargs):
    event = dict()
    event[Event.RUN_ID] = str(parent_runId)
    event[Event.CHILD_RUN_ID] = str(runId)
    event[Event.TIMESTAMP] = timestamp * 1000
    event[Event.TYPE] = Event.CHILD_STARTED
    event.update(kwargs)
    return event

def test_execution_finished_event(parent_runId, runId, timestamp, **kwargs):
    event = dict()
    event[Event.RUN_ID] = str(parent_runId)
    event[Event.CHILD_RUN_ID] = str(runId)
    event[Event.TIMESTAMP] = timestamp * 1000
    event[Event.TYPE] = Event.CHILD_FINISHED
    event.update(kwargs)
    return event

def timer(days_back, interval=24*60*60):
    now = int(time.time())
    start_time = now - (days_back * interval)
    for ts in xrange(start_time, now, interval):
        yield ts


# Main ###############


config, definitions = read_definitions()
print "Configuration:", config
print "Definitions:", definitions

store_reports()
fitNesseTestSpec = store_fitNesseTestSpecification()
cucumberTestSpec = store_cucumberTestSpecification()
store_TestSpecificationSet(fitNesseTestSpec, cucumberTestSpec)
gatlingTestSpec = store_gatlingTestSpecification()
store_dashboards()

for start_time in timer(config['runs']):
    runId = str(uuid.uuid1())
    print 'Generating test run', runId, 'for start time', time.ctime(start_time)
    finished_time = 0
    store_event(fitnesse_result_event(Event.IMPORT_STARTED, runId, start_time, lastModified=start_time * 1000))
    for definition in definitions:
        for result, finished_time in generate_permutations(definition, runId, start_time):
            store_event(result)
            createFitNesseTestPage(result['name'], result['result'], result['right'], result['wrong'], definition['team'])
    store_event(fitnesse_result_event(Event.IMPORT_FINISHED, runId, finished_time, duration=(finished_time - start_time)))
    store_event(fitnesse_result_event(Event.QUALIFICATION_COMPUTED, runId, finished_time, qualification=False))

cucumber_runId = UUID.randomUUID()
import_cucumber(cucumber_runId, cucumberTestSpec)

# Combine last run of the FitNesse demo suite with a cucumber run into a super
parent_runId  = UUID.randomUUID()
store_event(parent_execution_event(Event.EXECUTION_STARTED, parent_runId, start_time, testSpecification='super'))
store_event(child_execution_started_event(parent_runId, runId, start_time, testSpecification='super'))
store_event(test_execution_finished_event(parent_runId, runId, finished_time, testSpecification='super'))
store_event(child_execution_started_event(parent_runId, cucumber_runId, start_time - 1000, testSpecification='super'))
store_event(test_execution_finished_event(parent_runId, cucumber_runId, start_time, testSpecification='super'))
store_event(parent_execution_event(Event.EXECUTION_FINISHED, parent_runId, finished_time, testSpecification='super'))
