/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="A test specification", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class TestSpecification
extends BaseTestSpecification {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecification.class);
    @Property(description="Working directory for test execution")
    private String workingDirectory;
    @Property(description="Name of the test tool, such as JMeter, FitNesse or Cucumber")
    private String testToolName;
    @Property(description="Host where is test tool process is executed")
    private Host host;
    @Property(description="Pattern used to look for ")
    private String searchPattern;
    @Property(description="The report used to determine the outcome of a test run (success/fail)", required=false)
    private Qualification qualification;

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getTestToolName() {
        return this.testToolName;
    }

    public void setTestToolName(String testToolName) {
        this.testToolName = testToolName;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    public OverthereFile getRemotePath() {
        OverthereConnection hostConnection = this.getHost() != null ? this.getHost().getConnection() : LocalConnection.getLocalConnection();
        return hostConnection.getFile(this.workingDirectory);
    }

    public void doImport(UUID testRunId, TestTool testTool, EventHandler eventHandler) {
        this.doImport(testRunId, testTool, this.getRemotePath(), eventHandler);
    }

    public void doImport(UUID testRunId, TestTool testTool, OverthereFile remotePath, EventHandler eventHandler) {
        this.doImport(testRunId, testTool, remotePath, eventHandler, new ProgressCallback(){

            @Override
            public void update(int percentage) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(UUID testRunId, TestTool testTool, OverthereFile remotePath, EventHandler eventHandler, ProgressCallback progressCallback) {
        ImportHandler handler = new ImportHandler(eventHandler);
        try {
            int counter = 0;
            List<Importable> importables = testTool.findImportables(remotePath, new FileMatcher(remotePath, this.getSearchPattern()));
            progressCallback.update(++counter / (importables.size() + 1));
            for (Importable importable : importables) {
                try {
                    importable.doImport(testRunId, handler);
                    int percentage = ++counter * 100 / (importables.size() + 1);
                    progressCallback.update(percentage);
                }
                catch (Exception e) {
                    LOG.error("Unable to import test run" + importable, (Throwable)e);
                }
            }
        }
        finally {
            remotePath.getConnection().close();
        }
    }

    @Override
    public Qualification getQualification() {
        return this.qualification;
    }

    @Override
    public void setQualification(Qualification qualification) {
        this.qualification = qualification;
    }

    public static interface ProgressCallback {
        public void update(int var1);
    }

    public class ImportHandler
    implements EventHandler {
        private EventHandler eventHandler;
        public int count = 0;

        public ImportHandler(EventHandler eventHandler) {
            this.eventHandler = eventHandler;
        }

        @Override
        public void onReceive(Event event) throws Exception {
            LOG.debug("Importing event {}", (Object)event);
            this.eventHandler.onReceive(new Event(event, Event.props("testSpecification", TestSpecification.this.getName())));
            ++this.count;
        }
    }
}

