/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HostRepository {
    public static final String HOST_TYPE_OVERTHERE_JENKINS = "overthere.JenkinsHost";
    private final RepositoryService repository;

    @Autowired
    public HostRepository(RepositoryService repositoryService) {
        this.repository = repositoryService;
    }

    public Host findJenkinsHost(String addressToLookFor, int portToLookFor) {
        return this.findHost(addressToLookFor, portToLookFor, HOST_TYPE_OVERTHERE_JENKINS);
    }

    public Host findHost(String addressToLookFor, int portToLookFor, String hostType) {
        SearchParameters criteria = new SearchParameters().setType(Type.valueOf((String)hostType));
        List hosts = this.repository.listEntities(criteria);
        for (Host host : hosts) {
            String address = null;
            int port = -1;
            try {
                address = (String)host.getProperty("address");
                port = (Integer)host.getProperty("port");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!addressToLookFor.equals(address) || portToLookFor != port) continue;
            return host;
        }
        return null;
    }

    public Host createJenkinsHost(String address, int port, String jobName) {
        Host host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)HOST_TYPE_OVERTHERE_JENKINS)).newInstance("");
        host.setProperty("address", (Object)address);
        host.setProperty("port", (Object)port);
        host.setProperty("username", (Object)"jenkinsUser");
        host.setProperty("password", (Object)"jenkinsUserPassword");
        host.setOs(OperatingSystemFamily.UNIX);
        host.setProperty("jobName", (Object)jobName);
        host.setId("Infrastructure/" + jobName);
        this.repository.create((ConfigurationItem[])new Host[]{host});
        return host;
    }

    public Host findOrCreateJenkinsHost(String addressToLookFor, int portToLookFor, String jobName) {
        Host host = this.findJenkinsHost(addressToLookFor, portToLookFor);
        if (host != null) {
            return host;
        }
        return this.createJenkinsHost(addressToLookFor, portToLookFor, jobName);
    }

    public static Host create(String type, String address, String username, String password, String jobName) {
        Host host;
        if ("overthere.LocalHost".equalsIgnoreCase(type)) {
            host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.LocalHost")).newInstance("");
            host.setOs(OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        } else if ("overthere.SshHost".equalsIgnoreCase(type)) {
            host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.SshHost")).newInstance("");
            host.setProperty("address", (Object)address);
            host.setProperty("username", (Object)username);
            host.setProperty("password", (Object)password);
            host.setOs(OperatingSystemFamily.UNIX);
        } else if ("overthere.CifsHost".equalsIgnoreCase(type)) {
            host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)"overthere.CifsHost")).newInstance("");
            host.setProperty("address", (Object)address);
            host.setProperty("username", (Object)username);
            host.setProperty("password", (Object)password);
            host.setOs(OperatingSystemFamily.WINDOWS);
        } else if (HOST_TYPE_OVERTHERE_JENKINS.equalsIgnoreCase(type)) {
            host = (Host)DescriptorRegistry.getDescriptor((Type)Type.valueOf((String)HOST_TYPE_OVERTHERE_JENKINS)).newInstance("");
            host.setProperty("address", (Object)address);
            host.setProperty("username", (Object)username);
            host.setProperty("password", (Object)password);
            host.setProperty("jobName", (Object)jobName);
            host.setOs(OperatingSystemFamily.UNIX);
        } else {
            throw new AssertionError((Object)String.format("Protocol %s is not supported.", type));
        }
        return host;
    }
}

