/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.repository.HostRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationRepository {
    private final RepositoryService repository;
    private final HostRepository hosts;

    @Autowired
    public TestSpecificationRepository(RepositoryService repositoryService, HostRepository hosts) {
        this.repository = repositoryService;
        this.hosts = hosts;
    }

    public List<TestSpecification> findBy(String testToolName, String searchPattern, String workingDirectory) {
        SearchParameters criteria = new SearchParameters().setType(Type.valueOf(TestSpecification.class));
        criteria.addProperty("testToolName", testToolName);
        criteria.addProperty("searchPattern", searchPattern);
        criteria.addProperty("workingDirectory", workingDirectory);
        List result = this.repository.listEntities(criteria);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public List<TestSpecification> findWithHost(String testToolName, String searchPattern, String address, String workingDirectory, int port, String hostType) {
        List<TestSpecification> testSpecifications = this.findBy(testToolName, searchPattern, workingDirectory);
        ArrayList<TestSpecification> results = new ArrayList<TestSpecification>();
        if (testSpecifications.size() > 1) {
            Host host = this.hosts.findHost(address == null ? "" : address, port, hostType);
            if (host != null) {
                for (TestSpecification ts : testSpecifications) {
                    if (!ts.getHost().getId().equals(host.getId())) continue;
                    results.add(ts);
                }
            }
        } else if (testSpecifications.size() == 1) {
            return testSpecifications;
        }
        return testSpecifications;
    }

    public TestSpecification findFirstWithHost(String testToolName, String searchPattern, String address, String workingDirectory, int port, String hostType) {
        List<TestSpecification> testSpecifications = this.findWithHost(testToolName, searchPattern, address, workingDirectory, port, hostType);
        if (testSpecifications.size() == 1) {
            return testSpecifications.get(0);
        }
        return null;
    }
}

