/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.repository.TestTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/hosts")
@Produces(value={"application/json"})
public class HostController {
    private static final Logger LOG = LoggerFactory.getLogger(HostController.class);
    private final RepositoryService repositoryService;
    private final TestTools testTools;
    private final TestRunsRepository testRunsRepository;

    @Autowired
    public HostController(RepositoryService repositoryService, TestTools testTools, TestRunsRepository testRunsRepository) {
        this.repositoryService = repositoryService;
        this.testTools = testTools;
        this.testRunsRepository = testRunsRepository;
    }

    @GET
    @Path(value="/")
    public String treeForHost() throws JSONException {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Host.class));
        List<Host> allHosts = this.repositoryService.listEntities(query);
        if (allHosts == null) {
            allHosts = Collections.emptyList();
        }
        query = new SearchParameters().setType(Type.valueOf(BaseTestSpecification.class));
        List allTestSpecifications = this.repositoryService.listEntities(query);
        return this.createHostTree(allHosts, allTestSpecifications).toString();
    }

    protected JSONArray createHostTree(List<Host> allHosts, List<BaseTestSpecification> allTestSpecifications) throws JSONException {
        JSONArray jArray = new JSONArray();
        for (Host host : allHosts) {
            JSONObject child = new JSONObject();
            child.put("name", (Object)host.getName());
            child.put("type", (Object)host.getType());
            List<BaseTestSpecification> testSpecificationsUsingHost = this.getTestSpecificationsUsingHost(host.getId(), allTestSpecifications);
            if (testSpecificationsUsingHost != null) {
                child.put("testSpecifications", (Object)this.createTestSpecificationList(testSpecificationsUsingHost));
            }
            jArray.put((Object)child);
        }
        return jArray;
    }

    protected JSONArray createTestSpecificationList(List<BaseTestSpecification> testSpecifications) throws JSONException {
        JSONArray jArray = new JSONArray();
        for (BaseTestSpecification testSpecification : testSpecifications) {
            JSONObject child = new JSONObject();
            child.put("name", (Object)testSpecification.getName());
            child.put("type", (Object)testSpecification.getType());
            jArray.put((Object)child);
        }
        return jArray;
    }

    private List<BaseTestSpecification> getTestSpecificationsUsingHost(String hostId, List<BaseTestSpecification> allTestSpecifications) {
        ArrayList<BaseTestSpecification> testSpecifications = new ArrayList<BaseTestSpecification>();
        for (BaseTestSpecification testSpecification : allTestSpecifications) {
            if (!testSpecification.hasProperty("host") || !((Host)testSpecification.getProperty("host")).getId().equals(hostId)) continue;
            testSpecifications.add(testSpecification);
        }
        return testSpecifications;
    }
}

