/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ExecutableTestSpecification;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.HostRepository;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.TestTools;
import com.xebialabs.xltest.service.EventRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/import")
public class ImportController {
    private static final Logger LOG = LoggerFactory.getLogger(ImportController.class);
    private final TestTools testTools;
    private final RepositoryService repository;
    private final TestSpecificationRepository testSpecifications;
    private final HostRepository hosts;
    private final EventRepository eventRepository;
    private final TestRunsRepository testRunsRepository;

    @Autowired
    public ImportController(TestTools testTools, RepositoryService repository, EventRepository eventRepository, TestRunsRepository testRunsRepository, TestSpecificationRepository testSpecificationRepository, HostRepository hosts) {
        this.testTools = testTools;
        this.repository = repository;
        this.eventRepository = eventRepository;
        this.testRunsRepository = testRunsRepository;
        this.testSpecifications = testSpecificationRepository;
        this.hosts = hosts;
    }

    @POST
    @Path(value="/{jobName:.+}")
    public Response importTestResultsSentByJenkins(@PathParam(value="jobName") String jobName, @Context HttpServletRequest request) throws Exception {
        TestSpecification testSpecification = this.findOrCreateTestSpecificationWithJenkinsHost(jobName, request.getParameter("tool"), request.getParameter("pattern"), request.getParameter("jenkinsHost"), Integer.parseInt(request.getParameter("jenkinsPort")));
        ServletInputStream inputStream = request.getInputStream();
        File localWorkspaceDirectory = Files.createTempDir();
        this.extract(localWorkspaceDirectory, (InputStream)inputStream);
        inputStream.close();
        LOG.info("Extracted zip content into: " + localWorkspaceDirectory.getAbsolutePath());
        UUID testRunId = UUID.randomUUID();
        TestTool testTool = this.testTools.findByName(testSpecification.getTestToolName());
        this.setDefaultQualificationIfAbsent(testSpecification, testTool.getCategory());
        final Qualifier qualifier = testSpecification.getQualification().getQualifier(testRunId, this.testRunsRepository);
        testSpecification.doImport(testRunId, testTool, LocalFile.valueOf((File)localWorkspaceDirectory), new EventHandler(){

            @Override
            public void onReceive(Event event) throws Exception {
                qualifier.update(event);
                ImportController.this.eventRepository.insert(event);
            }
        });
        this.eventRepository.insert(new Event(qualifier.getEvent(), Event.props("testSpecification", testSpecification.getName())));
        return Response.ok().build();
    }

    private void extract(File baseDir, InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File file = new File(baseDir, entry.getName());
            LOG.debug("Copying {} into file {}", (Object)entry.getName(), (Object)file);
            Files.createParentDirs((File)file);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zis), (File)file);
        }
    }

    private void setDefaultQualificationIfAbsent(TestSpecification testSpecification, String testToolCategory) {
        if (testSpecification.getQualification() == null) {
            String defaultQualificationId = null;
            if (testToolCategory.equals("functional")) {
                defaultQualificationId = "Configuration/Reports/default-functional-tests-qualifier";
            } else if (testToolCategory.equals("performance")) {
                defaultQualificationId = "Configuration/Reports/default-performance-tests-qualifier";
            }
            try {
                Qualification defaultQualification = (Qualification)this.repository.read(defaultQualificationId);
                testSpecification.setQualification(defaultQualification);
                this.repository.update((ConfigurationItem[])new TestSpecification[]{testSpecification});
                LOG.debug("testSpecification {} updated with default qualification {}", (Object)testSpecification.getId(), (Object)defaultQualificationId);
            }
            catch (Exception exception) {
                LOG.warn("Couldn't set default qualification {} on testSpecification {}", (Object)defaultQualificationId, (Object)testSpecification.getId());
            }
        }
    }

    private TestSpecification findOrCreateTestSpecificationWithJenkinsHost(String jobName, String testToolName, String searchPattern, String jenkinsHostAddress, int port) {
        TestSpecification testSpecification = this.testSpecifications.findFirstWithHost(testToolName, searchPattern, jenkinsHostAddress, ".", port, "overthere.JenkinsHost");
        if (testSpecification != null) {
            return testSpecification;
        }
        testSpecification = new ExecutableTestSpecification();
        testSpecification.setId("Configuration/TestSpecifications/" + jobName);
        testSpecification.setWorkingDirectory(".");
        testSpecification.setTestToolName(testToolName);
        testSpecification.setSearchPattern(searchPattern);
        Host host = this.hosts.findOrCreateJenkinsHost(jenkinsHostAddress, port, jobName);
        testSpecification.setHost(host);
        this.repository.create((ConfigurationItem[])new TestSpecification[]{testSpecification});
        return testSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{testSpecificationId:.+}")
    @Produces(value={"text/event-stream"})
    public void getTestRun(@PathParam(value="testSpecificationId") String testSpecificationId, @Context HttpServletResponse response) throws Exception {
        TestSpecification testSpecification;
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Connection", "keep-alive");
        final PrintWriter writer = response.getWriter();
        try {
            testSpecification = (TestSpecification)this.repository.read("Configuration/TestSpecifications/" + testSpecificationId);
        }
        catch (NotFoundException e) {
            this.closeEventStream(writer, e.getMessage());
            return;
        }
        UUID testRunId = UUID.randomUUID();
        try {
            TestTool testTool = this.testTools.findByName(testSpecification.getTestToolName());
            this.setDefaultQualificationIfAbsent(testSpecification, testTool.getCategory());
            final Qualifier qualifier = testSpecification.getQualification().getQualifier(testRunId, this.testRunsRepository);
            testSpecification.doImport(testRunId, testTool, testSpecification.getRemotePath(), new EventHandler(){

                @Override
                public void onReceive(Event event) throws Exception {
                    qualifier.update(event);
                    ImportController.this.eventRepository.insert(event);
                }
            }, new TestSpecification.ProgressCallback(){

                @Override
                public void update(int percentage) {
                    ImportController.this.sendEvent(writer, percentage);
                }
            });
            this.eventRepository.insert(qualifier.getEvent());
        }
        finally {
            this.closeEventStream(writer);
        }
    }

    private void sendEvent(PrintWriter writer, int pct) {
        if (writer != null) {
            writer.write("event: event\n");
            writer.write("data: {\"percentage\":" + pct + "}\n\n");
            writer.flush();
        }
    }

    private void closeEventStream(PrintWriter writer) {
        if (writer != null) {
            writer.write("event: close\n");
            writer.write("data: {}\n\n");
            writer.close();
        }
    }

    private void closeEventStream(PrintWriter writer, String errorMessage) {
        if (writer != null) {
            writer.write("event: close\n");
            writer.write("data: {\"error\":\"" + errorMessage + "\"}\n\n");
            writer.close();
        }
    }
}

