/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.service.EventRepository;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/migrate")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class MigrationController {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationController.class);
    private final EventRepository eventRepository;

    @Autowired
    public MigrationController(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    @GET
    @Path(value="/")
    public Response migrate() {
        LOG.info("migration started");
        try {
            URL oldBaseUrl = new URL("http://localhost:9400");
            if (this.checkMigratable(oldBaseUrl)) {
                this.migrate(oldBaseUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)400).build();
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMigratable(URL oldBaseUrl) {
        block7: {
            HttpURLConnection connToOldES = null;
            try {
                URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_mappings");
                connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
                int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
                LOG.info("Connected to old ESs. Resp. code on old: " + responseCodeOnOldMappingUrl);
                if (responseCodeOnOldMappingUrl == 200) {
                    break block7;
                }
                LOG.error("Could not connect to one or both ES instances, see above.....");
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (connToOldES != null) {
                    connToOldES.disconnect();
                }
            }
        }
        LOG.info("Found old ES so we have a migratable situation");
        return true;
    }

    private void migrate(URL oldBaseUrl) {
        long now = System.currentTimeMillis();
        this.migrateRuns(oldBaseUrl);
        this.migrateResults(oldBaseUrl);
        long duration = System.currentTimeMillis() - now;
        LOG.info("Migration done in " + duration + " milliseconds");
    }

    private void migrateRuns(URL oldBaseUrl) {
        List<Event> startTestRunEvents = this.getStartOrFinishTestRunEvents(oldBaseUrl, "startTestRun");
        List<Event> finishTestRunEvents = this.getStartOrFinishTestRunEvents(oldBaseUrl, "finishTestRun");
        Set<String> runIdsStartedButNotFinished = this.getRunIdsStartedButNotFinished(startTestRunEvents, finishTestRunEvents);
        LOG.info("I found " + startTestRunEvents.size() + " start events and " + finishTestRunEvents.size() + " finish events");
        LOG.info("Searching jobStatus events. This may take a while as there are hundreds of thousands of them....");
        Map<String, List<Event>> jobStatusEventsPerRunId = this.getJobStatusEventsPerRunId(oldBaseUrl);
        LOG.info("I found " + jobStatusEventsPerRunId.keySet().size() + " run_ids in jobStatus events");
        List<Event> additionalFinishTestRunEvents = this.compensateMissingFinishes(runIdsStartedButNotFinished, jobStatusEventsPerRunId);
        LOG.info("I found " + additionalFinishTestRunEvents.size() + " additional finish events after compensating");
        LOG.info("Now I have started: " + startTestRunEvents.size() + " start events " + (finishTestRunEvents.size() + additionalFinishTestRunEvents.size()) + " finish events in total");
        int totalInserted = 0;
        int inserted = this.insertEvents(startTestRunEvents);
        LOG.info("Inserted " + inserted + " start events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertEvents(finishTestRunEvents);
        LOG.info("Inserted " + inserted + " finish events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertEvents(additionalFinishTestRunEvents);
        LOG.info("Inserted " + inserted + " additional finish events. Total of inserted events is now: " + (totalInserted += inserted));
        inserted = this.insertEvents(jobStatusEventsPerRunId);
        LOG.info("Inserted " + inserted + " jobStatus events. Total of inserted events is now: " + (totalInserted += inserted));
    }

    private int insertEvents(Map<String, List<Event>> jobStatusEventsPerRunId) {
        int cnt = 0;
        for (String runid : jobStatusEventsPerRunId.keySet()) {
            cnt += this.insertEvents(jobStatusEventsPerRunId.get(runid));
        }
        return cnt;
    }

    private int insertEvents(List<Event> events) {
        boolean printProgress = events.size() > 2000;
        int cnt = 0;
        for (Event event : events) {
            this.insertEvent(event);
            if (!printProgress || ++cnt % 1000 != 999) continue;
            LOG.info("Inserted " + cnt + " events out of " + events.size());
        }
        return cnt;
    }

    private void insertEvent(Event event) {
        try {
            this.eventRepository.insert(event);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private List<Event> compensateMissingFinishes(Set<String> runIdsStartedButNotFinished, Map<String, List<Event>> jobStatusEventsPerRunId) {
        ArrayList<Event> missingFinishEvents = new ArrayList<Event>();
        for (String runId : runIdsStartedButNotFinished) {
            if (jobStatusEventsPerRunId.get(runId) == null) continue;
            Event lastFinishedJobStatus = this.getLastFinishTimeEvent(jobStatusEventsPerRunId.get(runId));
            HashMap<String, Object> otherProperties = new HashMap<String, Object>();
            otherProperties.put("testSpecification", lastFinishedJobStatus.get("testSpecification"));
            otherProperties.put("runId", runId);
            otherProperties.put("timestamp", lastFinishedJobStatus.get("timestamp"));
            Event compensatedFinishEvent = new Event("executionFinished", otherProperties);
            missingFinishEvents.add(compensatedFinishEvent);
        }
        return missingFinishEvents;
    }

    private Event getLastFinishTimeEvent(List<Event> list) {
        Event lastFinishTimeEvent = null;
        for (Event jobStatus : list) {
            if (lastFinishTimeEvent == null) {
                lastFinishTimeEvent = jobStatus;
                continue;
            }
            String lastFinishTimeEventFinishTime = (String)lastFinishTimeEvent.get("finishedTime");
            String jobStatusFinishTime = (String)jobStatus.get("finishedTime");
            if (lastFinishTimeEventFinishTime == null || jobStatusFinishTime == null || Long.parseLong(lastFinishTimeEventFinishTime) >= Long.parseLong(jobStatusFinishTime)) continue;
            lastFinishTimeEvent = jobStatus;
        }
        return lastFinishTimeEvent;
    }

    private Set<String> getRunIdsStartedButNotFinished(List<Event> startTestRunEvents, List<Event> finishTestRunEvents) {
        Set<String> startedRunIds = this.getRunIdsFromEvents(startTestRunEvents);
        Set<String> finishedRunIds = this.getRunIdsFromEvents(finishTestRunEvents);
        startedRunIds.removeAll(finishedRunIds);
        return startedRunIds;
    }

    private Set<String> getRunIdsFromEvents(List<Event> startTestRunEvents) {
        HashSet<String> runIds = new HashSet<String>();
        for (Event ev : startTestRunEvents) {
            String runId = (String)ev.get("runId");
            runIds.add(runId);
        }
        return runIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> getStartOrFinishTestRunEvents(URL oldBaseUrl, String startOrFinish) {
        ArrayList<Event> startTestRunEvents = new ArrayList<Event>();
        HttpURLConnection connToOldES = null;
        HttpURLConnection connToNewES = null;
        InputStream inputStream = null;
        try {
            URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:" + startOrFinish + "&size=1000000");
            connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
            int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
            if (responseCodeOnOldMappingUrl == 200) {
                inputStream = connToOldES.getInputStream();
                JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                for (int i = 0; i < realHits.size(); ++i) {
                    JSONObject startOrFinishTestRun = (JSONObject)realHits.get(i);
                    JSONObject source = (JSONObject)startOrFinishTestRun.get((Object)"_source");
                    HashMap<String, Object> otherProperties = new HashMap<String, Object>();
                    for (String key : source.keySet()) {
                        if (key.equals("testSetId")) {
                            otherProperties.put("testSpecification", source.get((Object)key));
                        }
                        if (key.equals("run_id")) {
                            otherProperties.put("runId", source.get((Object)key));
                        }
                        if (!key.equals("_ts")) continue;
                        otherProperties.put("timestamp", source.get((Object)key));
                    }
                    String modernType = "executionStarted";
                    if ("finishTestRun".equals(startOrFinish)) {
                        modernType = "executionFinished";
                    }
                    Event modernEvent = new Event(modernType, otherProperties);
                    startTestRunEvents.add(modernEvent);
                }
            } else {
                LOG.error("Could not retrieve instances of the " + startOrFinish + " type");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
            if (connToNewES != null) {
                connToNewES.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return startTestRunEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Event>> getJobStatusEventsPerRunId(URL oldBaseUrl) {
        HashMap<String, List<Event>> jobStatusEventsPerRunId = new HashMap<String, List<Event>>();
        HttpURLConnection connToOldES = null;
        HttpURLConnection connToNewES = null;
        InputStream inputStream = null;
        try {
            URL oldMappingUrl = new URL(oldBaseUrl, "xltest/_search?q=type:jobStatus&size=1000000");
            connToOldES = (HttpURLConnection)oldMappingUrl.openConnection();
            int responseCodeOnOldMappingUrl = connToOldES.getResponseCode();
            if (responseCodeOnOldMappingUrl == 200) {
                inputStream = connToOldES.getInputStream();
                JSONObject result = (JSONObject)JsonProviderFactory.createProvider().parse(inputStream);
                JSONObject hitsAsObject = (JSONObject)result.get((Object)"hits");
                JSONArray realHits = (JSONArray)hitsAsObject.get((Object)"hits");
                LOG.info("Have to process " + realHits.size() + " jobStatus Events");
                for (int i = 0; i < realHits.size(); ++i) {
                    JSONObject startOrFinishTestRun = (JSONObject)realHits.get(i);
                    JSONObject source = (JSONObject)startOrFinishTestRun.get((Object)"_source");
                    HashMap<String, Object> otherProperties = new HashMap<String, Object>();
                    if (i % 1000 == 999) {
                        LOG.info("Processed " + (i + 1) + " jobStatus Events");
                    }
                    for (String key : source.keySet()) {
                        if (key.equals("testSetDefinition")) {
                            otherProperties.put("testSpecification", source.get((Object)key));
                        }
                        if (key.equals("run_id")) {
                            otherProperties.put("runId", source.get((Object)key));
                        }
                        if (key.equals("_ts")) {
                            otherProperties.put("timestamp", source.get((Object)key));
                        }
                        if (key.equals("startTime")) {
                            otherProperties.put("startTime", source.get((Object)key));
                        }
                        if (!key.equals("finishedTime")) continue;
                        otherProperties.put("finishedTime", source.get((Object)key));
                    }
                    Event modernEvent = new Event("jobStatus", otherProperties);
                    if (jobStatusEventsPerRunId.get(modernEvent.get("runId")) == null) {
                        jobStatusEventsPerRunId.put((String)modernEvent.get("runId"), new ArrayList());
                    }
                    ((List)jobStatusEventsPerRunId.get((String)modernEvent.get("runId"))).add(modernEvent);
                }
            } else {
                LOG.error("Could not retrieve instances of the jobStatus type");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connToOldES != null) {
                connToOldES.disconnect();
            }
            if (connToNewES != null) {
                connToNewES.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return jobStatusEventsPerRunId;
    }

    private void migrateResults(URL oldBaseUrl) {
        LOG.error("migrateResults: Not implemented yet");
    }
}

