/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EventRepository {
    private final Object client;
    private final Method insertMethod;
    private final Method queryMethod;

    public EventRepository(Object client) throws NoSuchMethodException {
        this.client = client;
        this.insertMethod = client.getClass().getDeclaredMethod("insert", String.class, String.class);
        this.queryMethod = client.getClass().getDeclaredMethod("query", String.class);
    }

    public void insert(Event event) throws ReflectiveOperationException {
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        String content = jsonProvider.toJson(event.getProperties());
        this.insertMethod.invoke(this.client, event.getType(), content);
    }

    public List<Event> query(String query) {
        try {
            return this.parseElasticSearchJson((List)this.queryMethod.invoke(this.client, query));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to read from internal store", e);
        }
    }

    private List<Event> parseElasticSearchJson(List<String> hits) {
        if (hits == null) {
            return Collections.emptyList();
        }
        ArrayList<Event> retrievedEvents = new ArrayList<Event>(hits.size());
        for (String hit : hits) {
            Map object = (Map)JsonProviderFactory.createProvider().parse(hit);
            retrievedEvents.add(new Event(object));
        }
        return retrievedEvents;
    }
}

