#
# Basic execution of test cases on a host
#
from org.slf4j import LoggerFactory
from com.xebialabs.overthere.util import CapturingOverthereExecutionOutputHandler
from com.xebialabs.overthere import OverthereFile
import java.util.Date as Date
import com.xebialabs.xltest.domain.Event as Event

LOG = LoggerFactory.getLogger("Local Test run")

host = self.host
if host.hasProperty('jobParameters'):
    host.setProperty('jobParameters', parameters)
connection = host.getConnection()
exitCode = -1
importStartDate = Date()
eventHandler.onReceive(Event(testRunId, Event.EXECUTION_STARTED, {"commandLine": resolvedCommandLine, "parameters": parameters}))
try:
    LOG.info("Performing: " + str(self.cmdLine) + " on host " + str(host))
    stdoutHandler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    stderrHandler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    workingDirectory = self.getWorkingDirectory()
    if workingDirectory and (len(str(workingDirectory)) > 0):
        connection.setWorkingDirectory(connection.getFile(str(workingDirectory)))
        LOG.info('Set up the handlers, now executing in working directory %s...' % str(self.getWorkingDirectory()))
    else:
        LOG.info("Set up the handlers, now executing in default working directory...")
    exitCode = connection.execute(stdoutHandler, stderrHandler, self.getCmdLine(resolvedCommandLine))
    for line in stdoutHandler.getOutputLines():
        LOG.info("output: " + line)
    for line in stderrHandler.getOutputLines():
        LOG.error("error: " + line)
    LOG.info("All done, no exceptions")
finally:
    connection.close()
    # TODO: add "failureReason" property when needed.
    eventHandler.onReceive(Event(testRunId, Event.EXECUTION_FINISHED, {"exitCode": exitCode}))

resultHolder.setResult(exitCode)
