/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.local.state.meta.LocalGatewayMetaState;
import org.elasticsearch.gateway.local.state.meta.TransportNodesListGatewayMetaState;
import org.elasticsearch.gateway.local.state.shards.LocalGatewayShardsState;
import org.elasticsearch.index.gateway.local.LocalIndexGatewayModule;

public class LocalGateway
extends AbstractLifecycleComponent<Gateway>
implements Gateway,
ClusterStateListener {
    private final ClusterService clusterService;
    private final NodeEnvironment nodeEnv;
    private final LocalGatewayShardsState shardsState;
    private final LocalGatewayMetaState metaState;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;
    private final String initialMeta;
    private final ClusterName clusterName;

    @Inject
    public LocalGateway(Settings settings, ClusterService clusterService, NodeEnvironment nodeEnv, LocalGatewayShardsState shardsState, LocalGatewayMetaState metaState, TransportNodesListGatewayMetaState listGatewayMetaState, ClusterName clusterName) {
        super(settings);
        this.clusterService = clusterService;
        this.nodeEnv = nodeEnv;
        this.metaState = metaState;
        this.listGatewayMetaState = listGatewayMetaState;
        this.clusterName = clusterName;
        this.shardsState = shardsState;
        clusterService.addLast(this);
        this.initialMeta = this.componentSettings.get("initial_meta", settings.get("discovery.zen.minimum_master_nodes", "1"));
    }

    @Override
    public String type() {
        return "local";
    }

    @Override
    protected void doStart() throws ElasticsearchException {
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.clusterService.remove(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performStateRecovery(Gateway.GatewayStateRecoveredListener listener) throws GatewayException {
        void var11_15;
        ObjectOpenHashSet<String> nodesIds = ObjectOpenHashSet.from(this.clusterService.state().nodes().masterNodes().keys());
        this.logger.trace("performing state recovery from {}", nodesIds);
        TransportNodesListGatewayMetaState.NodesLocalGatewayMetaState nodesState = this.listGatewayMetaState.list((String[])nodesIds.toArray((Class)String.class), null).actionGet();
        int requiredAllocation = 1;
        try {
            if ("quorum".equals(this.initialMeta)) {
                if (nodesIds.size() > 2) {
                    requiredAllocation = nodesIds.size() / 2 + 1;
                }
            } else if ("quorum-1".equals(this.initialMeta) || "half".equals(this.initialMeta)) {
                if (nodesIds.size() > 2) {
                    requiredAllocation = (1 + nodesIds.size()) / 2;
                }
            } else if ("one".equals(this.initialMeta)) {
                requiredAllocation = 1;
            } else if ("full".equals(this.initialMeta) || "all".equals(this.initialMeta)) {
                requiredAllocation = nodesIds.size();
            } else if ("full-1".equals(this.initialMeta) || "all-1".equals(this.initialMeta)) {
                if (nodesIds.size() > 1) {
                    requiredAllocation = nodesIds.size() - 1;
                }
            } else {
                requiredAllocation = Integer.parseInt(this.initialMeta);
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to derived initial_meta from value {}", this.initialMeta);
        }
        if (nodesState.failures().length > 0) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                this.logger.warn("failed to fetch state from node", failedNodeException, new Object[0]);
            }
        }
        ObjectFloatOpenHashMap<String> indices = new ObjectFloatOpenHashMap<String>();
        MetaData electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeLocalGatewayMetaState nodeState : nodesState) {
            if (nodeState.metaData() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metaData();
            } else if (nodeState.metaData().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metaData();
            }
            for (ObjectCursor<IndexMetaData> objectCursor : nodeState.metaData().indices().values()) {
                indices.addTo(((IndexMetaData)objectCursor.value).index(), 1.0f);
            }
        }
        if (found < requiredAllocation) {
            listener.onFailure("found [" + found + "] metadata states, required [" + requiredAllocation + "]");
            return;
        }
        MetaData.Builder metaDataBuilder = MetaData.builder(electedGlobalState).removeAllIndices();
        boolean[] states = indices.allocated;
        KType[] keys = indices.keys;
        boolean bl = false;
        while (var11_15 < states.length) {
            if (states[var11_15]) {
                String index = (String)keys[var11_15];
                IndexMetaData electedIndexMetaData = null;
                int indexMetaDataCount = 0;
                for (TransportNodesListGatewayMetaState.NodeLocalGatewayMetaState nodeState : nodesState) {
                    IndexMetaData indexMetaData;
                    if (nodeState.metaData() == null || (indexMetaData = nodeState.metaData().index(index)) == null) continue;
                    if (electedIndexMetaData == null) {
                        electedIndexMetaData = indexMetaData;
                    } else if (indexMetaData.version() > electedIndexMetaData.version()) {
                        electedIndexMetaData = indexMetaData;
                    }
                    ++indexMetaDataCount;
                }
                if (electedIndexMetaData != null) {
                    if (indexMetaDataCount < requiredAllocation) {
                        this.logger.debug("[{}] found [{}], required [{}], not adding", index, indexMetaDataCount, requiredAllocation);
                    }
                    metaDataBuilder.put(electedIndexMetaData, false);
                }
            }
            ++var11_15;
        }
        ClusterState.Builder builder = ClusterState.builder(this.clusterName);
        builder.metaData(metaDataBuilder);
        listener.onSuccess(builder.build());
    }

    @Override
    public Class<? extends Module> suggestIndexGateway() {
        return LocalIndexGatewayModule.class;
    }

    @Override
    public void reset() throws Exception {
        FileSystemUtils.deleteRecursively(this.nodeEnv.nodeDataLocations());
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.metaState.clusterChanged(event);
        this.shardsState.clusterChanged(event);
    }
}

