/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.api.MetadataServiceImpl;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xltest.DemoData;
import com.xebialabs.xltest.Main;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.service.InMemoryRepositoryService;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.crypto.SecretKey;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@Configuration
@ComponentScan(value={"com.xebialabs.deployit.service.validation", "com.xebialabs.xltest"})
@ImportResource(value={"classpath:spring/xltest-context.xml"})
public class ContextConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)ContextConfig.class.getName());

    @Bean
    public MetadataService metadataService() {
        return new MetadataServiceImpl();
    }

    @Bean
    public Repository repository(RepositoryService repositoryService, Validator validator) {
        WorkDir workDir = null;
        return new RepositoryAdapter(repositoryService, validator, workDir);
    }

    @Bean
    public RepositoryServiceHolder repositoryServiceHolder(RepositoryService repositoryService) {
        return new RepositoryServiceHolder(repositoryService);
    }

    @Bean
    public RepositoryService repositoryService() throws IOException, RepositoryException {
        if ("true".equals(System.getProperty("testMode"))) {
            LOG.info("Using in memory repository service");
            return new InMemoryRepositoryService();
        }
        JackrabbitRepositoryFactoryBean factory = new JackrabbitRepositoryFactoryBean();
        factory.setHomeDir((Resource)new FileSystemResource("."));
        factory.setRepositoryName("xltest");
        ClassPathResource configuration = new ClassPathResource("jackrabbit-repository.xml");
        factory.setConfiguration((Resource)configuration);
        factory.setAutoInitialize(true);
        ServerConfiguration deployitConfig = new ServerConfiguration();
        deployitConfig.setDefaults();
        factory.setDeployitConfig(deployitConfig);
        factory.afterPropertiesSet();
        javax.jcr.Repository repo = factory.getObject();
        SecretKey secretKey = DeployitKeys.getPasswordEncryptionKey((String)"keyStorePassword");
        PasswordEncrypter.init((SecretKey)secretKey);
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        JcrRepositoryService jcrRepositoryService = new JcrRepositoryService(new JcrTemplate(repo, deployitConfig), passwordEncrypter);
        new DemoData().provision(Main.booter, (RepositoryService)jcrRepositoryService);
        return jcrRepositoryService;
    }

    @Bean
    public EventRepository eventRepository() throws NoSuchMethodException {
        return new EventRepository(Main.booter);
    }

    @Bean
    public ExecutorService executorService() {
        return new ForkJoinPool(32);
    }
}

