/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.xebialabs.xltest.ContextConfig;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.plugins.spring.SpringContextLoaderListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class XLTest {
    private Server server;
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private static final String SPRING_CONFIG = "classpath:spring/xltest-context.xml";

    public void startWebApp() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(10);
        threadPool.setMaxThreads(1000);
        this.server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.webAppPortNumber());
        connector.setHost(this.webAppBindAddress());
        this.server.setConnectors(new Connector[]{connector});
        this.setupRestContext(this.server);
        this.server.start();
        this.server.setStopAtShutdown(true);
    }

    private String webAppBindAddress() {
        return System.getProperty("xltest.host", "0.0.0.0");
    }

    public int webAppPortNumber() {
        return Integer.getInteger("xltest.port", 6516);
    }

    public void stopWebApp() throws Exception {
        this.server.stop();
        this.server.join();
    }

    private void setupRestContext(Server server) {
        WebAppContext context = new WebAppContext();
        context.setContextPath("");
        context.setInitParameter(SPRING_CTX_CFG_LOCATION_KEY, ContextConfig.class.getName());
        context.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        context.addEventListener((EventListener)new ResteasyBootstrap());
        context.addEventListener((EventListener)new SpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        context.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        context.getInitParams().put("resteasy.document.expand.entity.references", "false");
        context.addServlet(servletHolder, "/*");
        context.setResourceBase(".");
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        context.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        server.setHandler((Handler)context);
    }
}

