/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.Globbit;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTestTool
implements TestTool {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalFile retrieveFiles(OverthereFile remoteFile) {
        LocalFile tempFolder = null;
        try {
            if (remoteFile instanceof LocalFile) {
                LocalFile localFile = (LocalFile)remoteFile;
                return localFile;
            }
            tempFolder = this.getLocalTempFolder();
            this.logger.info("Will copy files from {} to {}", (Object)remoteFile, (Object)tempFolder);
            remoteFile.copyTo((OverthereFile)tempFolder);
            this.logger.info("Copied FitNesseRoot to {}", (Object)tempFolder);
            LocalFile localFile = tempFolder;
            return localFile;
        }
        finally {
            if (tempFolder != null) {
                tempFolder.getConnection().close();
            }
        }
    }

    private LocalFile getLocalTempFolder() {
        File tempFile;
        try {
            tempFile = File.createTempFile("xltesttool", "");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temp file", e);
        }
        tempFile.delete();
        tempFile.mkdirs();
        LocalConnection localConnection = new LocalConnection("local", new ConnectionOptions());
        return new LocalFile(localConnection, tempFile);
    }

    @Override
    public Collection<OverthereFile> findTestResultPaths(FileMatcher pattern) {
        return new Globbit().find(pattern);
    }

    protected final Collection<OverthereFile> globbit(OverthereFile file, FileMatcher fileMatcher) {
        return new Globbit().find(fileMatcher);
    }
}

