/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.repository.TestRunsRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="Base type for test run qualifiers", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Qualification
extends ScriptedConfigurationItem {
    private static final Logger LOG = LoggerFactory.getLogger(Qualification.class);

    public Qualifier getQualifier(final UUID testRunId, final TestRunsRepository testRunsRepository) {
        return new Qualifier(){
            private List<Event> events = new ArrayList<Event>();

            @Override
            public void update(Event event) {
                this.events.add(event);
            }

            @Override
            public Boolean getQualificationResult() {
                ScriptContext context = Qualification.this.newScriptContext();
                context.setAttribute("events", this.events, 100);
                context.setAttribute("testRun", testRunsRepository.getTestRunFromEvents(this.events), 100);
                context.setAttribute("testRuns", testRunsRepository, 100);
                try {
                    Object result = Qualification.this.execute(context, Qualification.this);
                    return (Boolean)result;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not perform qualification of the run.", e);
                }
            }

            @Override
            public Event getEvent() {
                return new Event(testRunId, "qualificationComputed", Event.props("qualification", this.getQualificationResult()));
            }
        };
    }
}

