/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain.freemarker;

import com.xebialabs.xltest.domain.TestRun;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Report
extends com.xebialabs.xltest.domain.Report {
    private static Logger LOG = LoggerFactory.getLogger(Report.class);

    @Override
    public String compute(TestRun testRun) {
        String format;
        try {
            format = this.readTemplateFile(this.getScriptLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not perform freemarker report transformation.", e);
        }
        HashMap<String, Object> templateProperties = new HashMap<String, Object>(this.getAttributes());
        templateProperties.put("testRuns", this.getTestRunsRepository());
        templateProperties.put("testRun", testRun);
        templateProperties.put("this", this);
        for (String key : templateProperties.keySet()) {
            LOG.debug("freemarker report has context property: " + key + " with value: " + templateProperties.get(key) + " (instance of " + templateProperties.get(key).getClass().getName() + ")");
        }
        return this.format(templateProperties, format);
    }

    private String readTemplateFile(String fileName) throws IOException {
        String line;
        InputStream is = this.getClass().getResourceAsStream("/" + fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String format(Map<String, Object> properties, String format) {
        try {
            Configuration cfg = new Configuration();
            cfg.clearTemplateCache();
            Template t = new Template(this.getScriptLocation(), (Reader)new StringReader(format), cfg);
            StringWriter sw = new StringWriter();
            t.process(properties, (Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        catch (TemplateException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String nextDate(Date date) {
        Date nextDate = new Date(date.getTime() + 86400000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(nextDate);
    }

    public String previousDate(Date date) {
        Date previousDate = new Date(date.getTime() - 86400000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(previousDate);
    }

    public String thisDay(Long date) {
        SimpleDateFormat format = new SimpleDateFormat("dd");
        return format.format(new Date(date));
    }

    public String getAttributeAsString(String key) {
        if (this.getAttributes() != null) {
            return this.getAttributes().get(key).toString();
        }
        return "";
    }
}

