/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import com.xebialabs.xltest.view.ExecutionParameters;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/execute")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ExecuteController {
    private static final Logger LOG = LoggerFactory.getLogger(ExecuteController.class);
    private final RepositoryService repository;
    private final ExecutorService executorService;
    private final EventRepository eventRepository;
    private final AutowireCapableBeanFactory beanFactory;

    @Autowired
    public ExecuteController(RepositoryService repository, ExecutorService executorService, EventRepository eventRepository, AutowireCapableBeanFactory beanFactory) {
        this.repository = repository;
        this.executorService = executorService;
        this.eventRepository = eventRepository;
        this.beanFactory = beanFactory;
    }

    @POST
    @Path(value="{testSpecificationId}")
    public Response execute(@PathParam(value="testSpecificationId") String testSpecificationId, ExecutionParameters executionParameters) throws IOException, InterruptedException {
        final String id = testSpecificationId.startsWith("Configuration/TestSpecifications/") ? testSpecificationId : "Configuration/TestSpecifications/" + testSpecificationId;
        ConfigurationItem objectRead = this.repository.read(id);
        if (!(objectRead instanceof Executable)) {
            return Response.status((int)400).entity((Object)"{\"error\":\"TestSpecification not executable\"}").build();
        }
        final Executable executableTestSpecification = (Executable)objectRead;
        ExecutionParameterRequest request = executableTestSpecification.toExecutionParameterRequest();
        if (!executionParameters.satisfies(request)) {
            return Response.status((int)422).entity((Object)request).build();
        }
        if (executableTestSpecification.updateExecutionProperties(executionParameters.getCommandLine(), this.fetchHost(executionParameters))) {
            this.repository.update(new ConfigurationItem[]{objectRead});
        }
        this.beanFactory.autowireBean((Object)executableTestSpecification);
        final UUID testRunId = UUID.randomUUID();
        final Map<String, String> parameters = executionParameters.getParameters();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    executableTestSpecification.execute(testRunId, parameters, new EventHandler(){

                        @Override
                        public void onReceive(Event event) throws Exception {
                            ExecuteController.this.eventRepository.insert(event);
                        }
                    });
                }
                catch (Throwable t) {
                    LOG.error("Error while executing the test specification {}", (Object)id, (Object)t);
                }
            }
        });
        return Response.ok((Object)("{ \"taskId\": \"" + testRunId + "\"}")).build();
    }

    private Host fetchHost(ExecutionParameters executionParameters) {
        if (executionParameters.getHostId() == null) {
            return null;
        }
        return (Host)this.repository.read(executionParameters.getHostId());
    }
}

