/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.serialize.BasicMessageBodyWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.springframework.stereotype.Component;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

@Component
@Provider
@Produces(value={"application/json"})
public class ListOfTestSpecificationsWriter
extends BasicMessageBodyWriter<List<TestSpecification>> {
    @Override
    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        if (type == null) {
            return true;
        }
        Type containedType = ((ParameterizedTypeImpl)type).getActualTypeArguments()[0];
        return TestSpecification.class.isAssignableFrom(containedType.getClass());
    }

    @Override
    protected void writeJson(List<TestSpecification> testSpecifications, JSONWriter writer) throws JSONException {
        writer.array();
        for (TestSpecification testSpecification : testSpecifications) {
            this.writeJson(testSpecification, writer);
        }
        writer.endArray();
    }

    @Override
    protected void writeJson(TestSpecification testSpecification, JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("id").value((Object)testSpecification.getId());
        writer.key("name").value((Object)testSpecification.getName());
        writer.key("testToolName").value((Object)testSpecification.getTestToolName());
        writer.key("searchPattern").value((Object)testSpecification.getSearchPattern());
        writer.endObject();
    }
}

