/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils.glob;

import com.google.common.base.Strings;
import com.xebialabs.overthere.OverthereFile;
import java.util.Date;
import org.springframework.util.AntPathMatcher;

public class FileMatcher {
    private OverthereFile searchRoot;
    private String syntaxAndPattern;
    private Date lastModifiedDateAfter;
    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public FileMatcher(OverthereFile searchRoot, String pattern) {
        this.searchRoot = searchRoot;
        this.syntaxAndPattern = searchRoot.getPath() + searchRoot.getConnection().getHostOperatingSystem().getFileSeparator() + pattern;
    }

    public FileMatcher withLastModifiedDateAfter(Date modifiedDate) {
        this.lastModifiedDateAfter = modifiedDate;
        return this;
    }

    public boolean match(OverthereFile file) {
        boolean matched = true;
        if (!Strings.isNullOrEmpty((String)this.syntaxAndPattern)) {
            boolean bl = matched = matched && this.pathMatcher.match(this.syntaxAndPattern, file.getPath());
        }
        if (this.lastModifiedDateAfter != null) {
            matched = matched && file.lastModified() > this.lastModifiedDateAfter.getTime();
        }
        return matched;
    }

    public OverthereFile getSearchRoot() {
        return this.searchRoot;
    }
}

