/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.view;

import com.google.common.base.Strings;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import java.util.Map;

public class ExecutionParameters {
    private final String commandLine;
    private final String hostId;
    private final Map<String, String> parameters;

    public ExecutionParameters(String commandLine, String hostId, Map<String, String> parameters) {
        this.commandLine = commandLine;
        this.hostId = hostId;
        this.parameters = parameters;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String getHostId() {
        return this.hostId;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isEmpty() {
        return this.parameters == null;
    }

    public boolean satisfies(ExecutionParameterRequest request) {
        if (!this.isExecutable() && !request.isExecutable()) {
            return false;
        }
        if (request.hasParameters()) {
            return this.parameters != null;
        }
        return true;
    }

    public boolean isExecutable() {
        return !Strings.isNullOrEmpty((String)this.commandLine) && this.hostId != null;
    }
}

