/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.gatling;

import com.google.common.base.Strings;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.gatling.GatlingGlobalStatsJsonParser;
import com.xebialabs.xltest.gatling.GatlingGlobalStatsReport;
import com.xebialabs.xltest.gatling.Line;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.UUID;

public class GatlingSimulationLogImporter
implements Importable {
    private OverthereFile gatlingReportDir;

    public GatlingSimulationLogImporter(OverthereFile gatlingReportDir) {
        this.gatlingReportDir = gatlingReportDir;
    }

    public void doImport(UUID testRunId, EventHandler eventHandler) throws Exception {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.gatlingReportDir.getFile("simulation.log").getInputStream()));
        String firstLine = bufferedReader.readLine();
        String last = null;
        while ((line = bufferedReader.readLine()) != null) {
            last = line;
        }
        Event startEvent = this.readFirstLine(testRunId, firstLine);
        this.storeEvents(eventHandler, startEvent);
        Event resultEvent = this.parseGlobalStatsReport(testRunId, this.gatlingReportDir);
        Event finishEvent = this.readLastLine(testRunId, last, (Long)startEvent.get("timestamp"));
        this.storeEvents(eventHandler, finishEvent, resultEvent);
    }

    private Event readFirstLine(UUID testRunId, String firstLine) throws Exception {
        if (!Strings.isNullOrEmpty((String)firstLine)) {
            Line line = Line.parseLine(firstLine);
            return new Event(testRunId, "executionStarted", Event.props((Object[])new Object[]{"timestamp", line.getStartTime(), "simulationName", line.getSimulationName()}));
        }
        return null;
    }

    private Event readLastLine(UUID testRunId, String lastLine, Long startTime) throws Exception {
        if (!Strings.isNullOrEmpty((String)lastLine)) {
            Line line = Line.parseLine(lastLine);
            return new Event(testRunId, "executionFinished", Event.props((Object[])new Object[]{"timestamp", line.getEndTime(), "duration", line.getEndTime() - startTime}));
        }
        return null;
    }

    private Event parseGlobalStatsReport(UUID testRunId, OverthereFile simulationReportFolder) throws Exception {
        File globalStatsJson = new File(simulationReportFolder.getPath() + File.separator + "js" + File.separator + "global_stats.json");
        GatlingGlobalStatsReport statsReport = GatlingGlobalStatsJsonParser.parse(globalStatsJson);
        return new Event(testRunId, "performanceResult", statsReport.toMap());
    }

    private void storeEvents(EventHandler eventHandler, Event ... events) throws Exception {
        for (Event event : events) {
            eventHandler.onReceive(event);
        }
    }
}

