/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.google.common.collect.Lists;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import com.xebialabs.xltest.jenkins.JenkinsConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class JenkinsFile
extends BaseOverthereFile<JenkinsConnection> {
    private final String path;

    public JenkinsFile(JenkinsConnection connection, String path) {
        super((BaseOverthereConnection)connection);
        this.path = path;
    }

    public JenkinsFile(JenkinsConnection connection, JenkinsFile parent, String path) {
        super((BaseOverthereConnection)connection);
        this.path = parent.getPath() + "/" + path;
    }

    public String toString() {
        return "jenkins:" + this.path;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return new File(this.path).getName();
    }

    public OverthereFile getParentFile() {
        return new JenkinsFile((JenkinsConnection)this.connection, new File(this.path).getParent());
    }

    public boolean exists() {
        return ((JenkinsConnection)this.connection).getAbsoluteFileInLocalWorkspaceDirectory(this.path).exists();
    }

    public boolean canRead() {
        return this.exists();
    }

    public boolean canWrite() {
        return false;
    }

    public boolean canExecute() {
        return false;
    }

    public boolean isFile() {
        return ((JenkinsConnection)this.connection).getAbsoluteFileInLocalWorkspaceDirectory(this.path).isFile();
    }

    public boolean isDirectory() {
        return ((JenkinsConnection)this.connection).getAbsoluteFileInLocalWorkspaceDirectory(this.path).isDirectory();
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return ((JenkinsConnection)this.connection).getAbsoluteFileInLocalWorkspaceDirectory(this.path).length();
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(((JenkinsConnection)this.connection).getAbsoluteFileInLocalWorkspaceDirectory(this.path));
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeIOException("Cannot open " + (Object)((Object)this) + " for reading", (Throwable)exc);
        }
    }

    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(((JenkinsConnection)this.connection).getAbsoluteFileInLocalWorkspaceDirectory(this.path));
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeIOException("Cannot open " + (Object)((Object)this) + " for reading", (Throwable)exc);
        }
    }

    public void setExecutable(boolean executable) {
    }

    public void delete() {
    }

    public List<OverthereFile> listFiles() {
        ArrayList list = Lists.newArrayList();
        File absoluteLocalFile = ((JenkinsConnection)this.connection).getAbsoluteFileInLocalWorkspaceDirectory(this.path);
        int tempDirLength = absoluteLocalFile.getPath().length() - this.path.length();
        if (absoluteLocalFile == null) {
            return list;
        }
        File[] files = absoluteLocalFile.listFiles();
        if (files == null) {
            return list;
        }
        for (File each : files) {
            list.add(new JenkinsFile((JenkinsConnection)this.connection, each.getPath().substring(tempDirLength)));
        }
        return list;
    }

    public void mkdir() {
    }

    public void mkdirs() {
    }

    public void renameTo(OverthereFile dest) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JenkinsFile that = (JenkinsFile)((Object)o);
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

