/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.fitnesse.TestSummary;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.reporting.history.PageHistory;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.reporting.history.TestHistory;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileSystemPageFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.FileUtil;

public class PageHistoryExtractor {
    private static final Logger LOG = LoggerFactory.getLogger((String)PageHistoryExtractor.class.getName());
    private final File resultsDirectory;
    private final FileSystemPage root;

    public PageHistoryExtractor() {
        this(new File("./FitNesseRoot"));
    }

    public PageHistoryExtractor(File fitNesseRoot) {
        this.resultsDirectory = new File(fitNesseRoot, "/files/testResults");
        this.root = new FileSystemPageFactory().makePage(fitNesseRoot, "FitNesseRoot", null);
    }

    public List<Importable> tellMeAboutAllSuites() throws Exception {
        ArrayList<Importable> toImport = new ArrayList<Importable>();
        File[] resultFiles = this.resultsDirectory.listFiles();
        if (resultFiles == null) {
            return Collections.emptyList();
        }
        for (File pageNamedFile : resultFiles) {
            if (!pageNamedFile.isDirectory()) continue;
            String pageName = pageNamedFile.getName();
            LOG.info("Will try to make report for " + pageName);
            PageHistory pageHistory = this.getPageHistory(this.resultsDirectory, pageName);
            if (!this.pageHistoryIsSuite(pageHistory)) continue;
            for (Date date : pageHistory.datesInChronologicalOrder()) {
                Object executionReport = this.getExecutionReport(pageHistory, date);
                if (!(executionReport instanceof SuiteExecutionReport)) continue;
                toImport.add(new FitNesseSuite((SuiteExecutionReport)executionReport, pageName));
            }
        }
        LOG.info("All import options found");
        return toImport;
    }

    public void tellMeAboutReport(UUID testRunId, SuiteExecutionReport suiteExecutionReport, EventHandler eventHandler) throws Exception {
        for (SuiteExecutionReport.PageHistoryReference reference : suiteExecutionReport.getPageHistoryReferences()) {
            WikiPage thePage = this.root.getPageCrawler().getPage(PathParser.parse((String)reference.getPageName()));
            Set<String> tags = this.makeTags(thePage);
            String firstErrorMessage = this.findFirstErrorMessage(this.resultsDirectory, reference.getPageName(), new Date(reference.getTime()));
            Event event = new Event(testRunId, "functionalResult", new TestSummary(Event.normalizeName((String)reference.getPageName(), (Character)Character.valueOf('.')), tags, reference.getTime(), reference.getRunTimeInMillis(), reference.getTestSummary().getRight(), reference.getTestSummary().getWrong(), reference.getTestSummary().getWrong() + reference.getTestSummary().getExceptions() > 0 ? "FAILED" : "PASSED", reference.getTestSummary().getExceptions(), firstErrorMessage).toMap());
            eventHandler.onReceive(event);
        }
    }

    private Set<String> makeTags(WikiPage page) {
        if (page == null || page.isRoot()) {
            return PageHistoryExtractor.set(new String[0]);
        }
        String tags = page.getData().getAttribute("Suites");
        Set<String> tagSet = this.isNotBlank(tags) ? PageHistoryExtractor.set(tags.split(",")) : PageHistoryExtractor.set(new String[0]);
        tagSet.addAll(this.makeTags(page.getParent()));
        return tagSet;
    }

    private String findFirstErrorMessage(File resultsDirectory, String pageName, Date date) throws Exception {
        TestExecutionReport testExecutionReport = (TestExecutionReport)this.getExecutionReport(this.getPageHistory(resultsDirectory, pageName), date);
        return this.findFirstErrorMessage(testExecutionReport);
    }

    private String findFirstErrorMessage(TestExecutionReport testExecutionReport) {
        TestExecutionReport.TestResult testResult = (TestExecutionReport.TestResult)testExecutionReport.getResults().get(0);
        for (TestExecutionReport.InstructionResult instructionResult : testResult.getInstructions()) {
            for (TestExecutionReport.Expectation expectation : instructionResult.getExpectations()) {
                if ("fail".equals(expectation.getStatus())) {
                    return String.format("Actual: '%s'; Expected: '%s'", expectation.getActual(), expectation.getExpected());
                }
                if (!"error".equals(expectation.getStatus())) continue;
                return expectation.getEvaluationMessage();
            }
        }
        return null;
    }

    private <T extends ExecutionReport> T getExecutionReport(PageHistory pageHistory, Date date) throws Exception {
        TestResultRecord testResultRecord = pageHistory.get(date);
        return (T)ExecutionReport.makeReport((String)FileUtil.getFileContent((File)testResultRecord.getFile()));
    }

    private PageHistory getPageHistory(File resultsDirectory, String pageName) {
        TestHistory history = new TestHistory();
        history.readPageHistoryDirectory(resultsDirectory, pageName);
        return history.getPageHistory(pageName);
    }

    private boolean pageHistoryIsSuite(PageHistory pageHistory) throws Exception {
        Object report = this.getExecutionReport(pageHistory, pageHistory.getLatestDate());
        return report instanceof SuiteExecutionReport;
    }

    public static Set<String> set(String ... tags) {
        TreeSet<String> tagSet = new TreeSet<String>();
        for (String tag : tags) {
            String trimmed = tag.trim();
            if ("".equals(trimmed)) continue;
            tagSet.add(trimmed);
        }
        return tagSet;
    }

    private boolean isNotBlank(String tags) {
        return tags != null && !"".equals(tags);
    }

    private class FitNesseSuite
    implements Importable {
        private final SuiteExecutionReport executionReport;
        private final String pageName;

        public FitNesseSuite(SuiteExecutionReport executionReport, String pageName) {
            this.executionReport = executionReport;
            this.pageName = pageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void doImport(UUID testRunId, EventHandler eventHandler) {
            block10: {
                LOG.info("Importing {}", (Object)this.executionReport);
                long startTime = this.executionReport.getDate().getTime();
                eventHandler.onReceive(new Event(testRunId, "importStarted", Event.props((Object[])new Object[]{"fileName", this.executionReport.getRootPath(), "lastModified", this.executionReport.getDate().getTime(), "name", this.pageName})));
                PageHistoryExtractor.this.tellMeAboutReport(testRunId, this.executionReport, eventHandler);
                long duration = this.executionReport.getTotalRunTimeInMillis();
                try {
                    eventHandler.onReceive(new Event(testRunId, "importFinished", Event.props((Object[])new Object[]{"duration", duration})));
                }
                catch (Exception e) {
                    LOG.error("Unable to handle finish event properly. Such a shame!", (Throwable)e);
                }
                break block10;
                catch (Exception e) {
                    try {
                        LOG.error("Unable to import test run " + this.pageName + " for " + this.executionReport, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        long duration2 = this.executionReport.getTotalRunTimeInMillis();
                        try {
                            eventHandler.onReceive(new Event(testRunId, "importFinished", Event.props((Object[])new Object[]{"duration", duration2})));
                        }
                        catch (Exception e2) {
                            LOG.error("Unable to handle finish event properly. Such a shame!", (Throwable)e2);
                        }
                        throw throwable;
                    }
                    duration = this.executionReport.getTotalRunTimeInMillis();
                    try {
                        eventHandler.onReceive(new Event(testRunId, "importFinished", Event.props((Object[])new Object[]{"duration", duration})));
                    }
                    catch (Exception e3) {
                        LOG.error("Unable to handle finish event properly. Such a shame!", (Throwable)e3);
                    }
                }
            }
        }
    }
}

