<#macro STATUS title>
    <#assign shouldPrintHeader = true >
        <#list eventsFromThisRunMap?keys as suiteName>
          <#assign events = eventsFromThisRunMap[suiteName!""]![] >
          <#assign durationsTotal = 0>
          <#list events as resultEventInCurrentRun>
              <#if shouldPrintHeader >
                <tr>
                  <th colspan="5"><h3>${title}</h3></th>
                </tr>
                <tr>
                  <th>Component</th>
                  <th>Duration</th>
                  <th>Average</th>
                  <th>Runs</th>
                </tr>
                <#assign shouldPrintHeader = false >
              </#if>
              <#assign duration = resultEventInCurrentRun.duration>
              <#assign durationsTotal = durationsTotal + duration>
          </#list>
              <tr>
                <#assign suiteNameLength = suiteName?length>
                <#assign index = suiteName?index_of(";") + 1>
                <#assign suiteNameForDisplay = suiteName?substring(index, suiteNameLength)>
                <td>${suiteNameForDisplay}</td>
                <#assign durationInMinutes = (durationsTotal / 60000)?int>
                <#assign durationInSeconds = (durationsTotal / 1000)?int>
                <#assign durationInMilliSeconds = (durationsTotal - (durationInSeconds * 1000)) - (durationInMinutes * 60 * 1000) >
                <#if durationInMinutes &lt; 10>
                  <#assign durationInMinutes = "0" + durationInMinutes>
                </#if>
                <#if durationInSeconds &lt; 10>
                  <#assign durationInSeconds = "0" + durationInSeconds>
                </#if>
                <#if durationInMilliSeconds &lt; 10>
                  <#assign durationInMilliSeconds = "00" + durationInMilliSeconds>
                <#elseif durationInMilliSeconds &lt; 100>
                  <#assign durationInMilliSeconds = "0" + durationInMilliSeconds>
                </#if>
                <td>${durationInMinutes}m ${durationInSeconds}s ${durationInMilliSeconds}ms</td>
                
                <#assign events = eventsFromOtherRunsMap[suiteName!""]![] >
                <#assign durationsTotal = 0>
                <#list events as resultEventInOldRun>
                  <#assign duration = resultEventInOldRun.duration>
                  <#assign durationsTotal = durationsTotal + duration>
                </#list>
                <#if runs?size &gt; 0>
                  <#assign durationsTotal = (durationsTotal / (runs?size))?int>
                <#else>
                  <#assign durationsTotal = 0>
                </#if>
                <#assign durationInMinutes = (durationsTotal / 60000)?int>
                <#assign durationInSeconds = (durationsTotal / 1000)?int>
                <#assign durationInMilliSeconds = (durationsTotal - (durationInSeconds * 1000)) - (durationInMinutes * 60 * 1000) >
                <#if durationInMinutes &lt; 10>
                  <#assign durationInMinutes = "0" + durationInMinutes>
                </#if>
                <#if durationInSeconds &lt; 10>
                  <#assign durationInSeconds = "0" + durationInSeconds>
                </#if>
                <#if durationInMilliSeconds &lt; 10>
                  <#assign durationInMilliSeconds = "00" + durationInMilliSeconds>
                <#elseif durationInMilliSeconds &lt; 100>
                  <#assign durationInMilliSeconds = "0" + durationInMilliSeconds>
                </#if>
                <td>${durationInMinutes}m ${durationInSeconds}s ${durationInMilliSeconds}ms</td>
                <#assign numberOfDurations = runs?size + 1>
                <td>${numberOfDurations}</td>
              </tr>
        </#list>
</#macro>

<h1></h1>
<table>
  <tbody>
  <#assign runs = [testRun] >
  <#assign eventsFromThisRunMap = testRuns.getEventsFromRunsAsMapGroupedBy('name', 2, runs, 'type:functionalResult')>
  <#assign runs = testRuns.getPreviousRuns(testRun, this.getProperty('maxRunsInHistory')) >
  <#assign eventsFromOtherRunsMap = testRuns.getEventsFromRunsAsMapGroupedBy('name', 2, runs, 'type:functionalResult')>

<@STATUS title="Test execution duration overview per Component"/>
  </tbody>
</table>
