package com.xebialabs.xltest.xunit;

import java.util.*;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;

public class XUnitTestTool extends BaseTestTool {

	@Override
	public String getName() {
		return "xUnit";
	}
	
	@Override
	public String getCategory() {
		return TestToolCategory.FUNCTIONAL;
	}

    @Override
    public Collection<OverthereFile> findTestResultPaths(FileMatcher pattern) {
        Collection<OverthereFile> testResultFiles = super.findTestResultPaths(pattern);
        Set<OverthereFile> testResultDirectories = new HashSet<>();
        for (OverthereFile resultFile : testResultFiles) {
            testResultDirectories.add(resultFile.getParentFile());
        }
        return testResultDirectories;
    }

    @Override
	public List<Importable> findImportables(final OverthereFile searchPath, final FileMatcher fileMatcher) {
        Collection<OverthereFile> testResultFiles = globbit(searchPath, fileMatcher);

        List<Importable> importables = new ArrayList<>();
        for(OverthereFile testResult : testResultFiles) {
            String moduleName = moduleName(searchPath, testResult);
            importables.add(new XUnitReportXmlImporter(moduleName, testResult));
        }

        return importables;
	}

    @Override
    public String getSearchPattern() {
        return "**/TEST-*.xml";
    }

    public static String moduleName(OverthereFile searchPath, OverthereFile resultsPath) {
        if (resultsPath == null) {
            return null;
        }
        if (searchPath.equals(resultsPath.getParentFile())) {
            return resultsPath.getName();
        }
        return moduleName(searchPath, resultsPath.getParentFile());
    }
}
